/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher;

import com.turikhay.tlauncher.Bootstrapper;
import com.turikhay.tlauncher.TLauncherNoGraphics;
import com.turikhay.tlauncher.component.managers.ComponentManager;
import com.turikhay.tlauncher.component.managers.ProfileManager;
import com.turikhay.tlauncher.component.managers.VersionManager;
import com.turikhay.tlauncher.configuration.ArgumentParser;
import com.turikhay.tlauncher.configuration.Configuration;
import com.turikhay.tlauncher.configuration.LangConfiguration;
import com.turikhay.tlauncher.downloader.Downloader;
import com.turikhay.tlauncher.handlers.ExceptionHandler;
import com.turikhay.tlauncher.minecraft.MinecraftLauncher;
import com.turikhay.tlauncher.minecraft.MinecraftLauncherListener;
import com.turikhay.tlauncher.ui.TLauncherFrame;
import com.turikhay.tlauncher.ui.alert.Alert;
import com.turikhay.tlauncher.ui.console.Console;
import com.turikhay.tlauncher.ui.listeners.UpdaterUIListener;
import com.turikhay.tlauncher.ui.loc.Localizable;
import com.turikhay.tlauncher.ui.login.LoginForm;
import com.turikhay.tlauncher.updater.Updater;
import com.turikhay.util.FileUtil;
import com.turikhay.util.MinecraftUtil;
import com.turikhay.util.Time;
import com.turikhay.util.U;
import com.turikhay.util.logger.MirroredLinkedStringStream;
import com.turikhay.util.logger.PrintLogger;
import java.io.IOException;
import java.util.Locale;
import joptsimple.OptionSet;
import net.minecraft.launcher.OperatingSystem;

public class TLauncher {
    private static final double VERSION = 0.65;
    private static final String SETTINGS = "tlauncher.cfg";
    private static final String BRAND = "Original";
    private static final String[] DEFAULT_UPDATE_REPO = new String[]{"http://u.to/tlauncher-original-update-mirror-3/D9wMBg", "http://s1.mmods.ru/launcher/original.ini", "http://u.to/tlauncher-original/BlPcBA", "http://ru-minecraft.org/update/original.ini", "http://u.to/tlauncher-original-update/T4ASBQ", "http://5.9.120.11/update/original.ini", "http://u.to/tlauncher-original-update-mirror2/BIQSBQ", "http://dl.dropboxusercontent.com/u/6204017/update/original.ini"};
    private static final String[] OFFICIAL_REPO = new String[]{"http://s3.amazonaws.com/Minecraft.Download/"};
    private static final String[] EXTRA_REPO = new String[]{"http://5.9.120.11/update/versions/", "http://s1.mmods.ru/launcher/", "http://ru-minecraft.org/update/tlauncher/extra/", "http://dl.dropboxusercontent.com/u/6204017/update/versions/"};
    private static final String[] LIBRARY_REPO = new String[]{"https://libraries.minecraft.net/"};
    private static final String[] ASSETS_REPO = new String[]{"http://resources.download.minecraft.net/"};
    private static final String[] SERVER_LIST = null;
    private static TLauncher instance;
    private static String[] sargs;
    private static MirroredLinkedStringStream stream;
    private static PrintLogger print;
    private static Console console;
    private TLauncherState state;
    private LangConfiguration lang;
    private Configuration settings;
    private Downloader downloader;
    private Updater updater;
    private TLauncherFrame frame;
    private TLauncherNoGraphics loader;
    private ComponentManager manager;
    private VersionManager versionManager;
    private ProfileManager profileManager;
    public final OptionSet args;
    private MinecraftLauncher launcher;
    private UpdaterUIListener updaterListener;
    private boolean ready;

    public TLauncher(TLauncherState state, OptionSet set) throws Exception {
        if (state == null) {
            throw new IllegalArgumentException("TLauncherState can't be NULL!");
        }
        U.log(new Object[]{"TLauncher is loading in state", state});
        Time.start(this);
        instance = this;
        this.state = state;
        this.args = set;
        this.settings = Configuration.createConfiguration(set);
        this.reloadLocale();
        console = new Console(this.settings, print, "TLauncher Dev Console", this.settings.getConsoleType() == Configuration.ConsoleType.GLOBAL);
        if (state.equals((Object)TLauncherState.MINIMAL)) {
            console.setCloseAction(Console.CloseAction.KILL);
        }
        Console.updateLocale();
        this.manager = new ComponentManager();
        this.versionManager = this.manager.getVersionManager();
        this.profileManager = this.manager.getProfileManager();
        this.init();
        U.log("Started! (" + Time.stop(this) + " ms.)");
        FileUtil.deleteFile(MinecraftUtil.getSystemRelatedFile("tlauncher.ini"));
        this.ready = true;
    }

    private void init() {
        this.downloader = new Downloader(this);
        switch (this.state) {
            case FULL: {
                this.updaterListener = new UpdaterUIListener(this);
                this.updater = new Updater(this);
                this.updater.addListener(this.updaterListener);
                this.frame = new TLauncherFrame(this);
                LoginForm lf = this.frame.mp.defaultScene.loginForm;
                if (lf.autologin.isEnabled()) {
                    this.versionManager.startRefresh(true);
                    lf.autologin.setActive(true);
                } else {
                    this.versionManager.asyncRefresh();
                    this.updater.asyncFindUpdate();
                }
                this.profileManager.refresh();
                break;
            }
            case MINIMAL: {
                this.loader = new TLauncherNoGraphics(this);
            }
        }
        this.downloader.startLaunch();
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    public LangConfiguration getLang() {
        return this.lang;
    }

    public Configuration getSettings() {
        return this.settings;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public OptionSet getArguments() {
        return this.args;
    }

    public TLauncherFrame getFrame() {
        return this.frame;
    }

    public TLauncherNoGraphics getLoader() {
        return this.loader;
    }

    public static Console getConsole() {
        return console;
    }

    public ComponentManager getManager() {
        return this.manager;
    }

    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public UpdaterUIListener getUpdaterListener() {
        return this.updaterListener;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void reloadLocale() throws IOException {
        Locale locale = this.settings.getLocale();
        U.log("Selected locale: " + locale);
        if (this.lang == null) {
            this.lang = new LangConfiguration(this.settings.getLocales(), locale);
        } else {
            this.lang.setSelected(locale);
        }
        Alert.prepareLocal();
        Localizable.setLang(this.lang);
    }

    public void launch(MinecraftLauncherListener listener, boolean forceupdate) {
        this.launcher = new MinecraftLauncher(this, listener, forceupdate, true);
        this.launcher.start();
    }

    public boolean isLauncherWorking() {
        return this.launcher != null && this.launcher.isWorking();
    }

    public static void kill() {
        U.log("Good bye!");
        System.exit(0);
    }

    public void hide() {
        U.log("Hiding...");
        this.frame.setVisible(false);
    }

    public void show() {
        U.log("Here I am!");
        this.frame.setVisible(true);
    }

    public static double getVersion() {
        return 0.65;
    }

    public static String getBrand() {
        return BRAND;
    }

    public static String[] getUpdateRepos() {
        return DEFAULT_UPDATE_REPO;
    }

    public static String getSettingsFile() {
        return SETTINGS;
    }

    public static String[] getOfficialRepo() {
        return OFFICIAL_REPO;
    }

    public static String[] getExtraRepo() {
        return EXTRA_REPO;
    }

    public static String[] getLibraryRepo() {
        return LIBRARY_REPO;
    }

    public static String[] getAssetsRepo() {
        return ASSETS_REPO;
    }

    public static String[] getServerList() {
        return SERVER_LIST;
    }

    public static void main(String[] args) {
        ExceptionHandler handler = ExceptionHandler.getInstance();
        Thread.setDefaultUncaughtExceptionHandler(handler);
        U.setPrefix("[TLauncher]");
        stream = new MirroredLinkedStringStream();
        stream.setMirror(System.out);
        print = new PrintLogger(stream);
        stream.setLogger(print);
        System.setOut(print);
        TLauncherFrame.initLookAndFeel();
        try {
            TLauncher.launch(args);
        }
        catch (Throwable e) {
            U.log("Error launching TLauncher:");
            e.printStackTrace(print);
            Alert.showError(e, true);
        }
    }

    private static void launch(String[] args) throws Exception {
        U.log("Hello!");
        U.log("Starting TLauncher", BRAND, 0.65);
        U.log("Machine info:", OperatingSystem.getCurrentInfo());
        U.log("---");
        sargs = args;
        OptionSet set = ArgumentParser.parseArgs(args);
        if (set == null) {
            new TLauncher(TLauncherState.FULL, null);
            return;
        }
        if (set.has("help")) {
            ArgumentParser.getParser().printHelpOn(System.out);
        }
        TLauncherState state = TLauncherState.FULL;
        if (set.has("nogui")) {
            state = TLauncherState.MINIMAL;
        }
        new TLauncher(state, set);
    }

    public static String[] getArgs() {
        if (sargs == null) {
            sargs = new String[0];
        }
        return sargs;
    }

    public static TLauncher getInstance() {
        return instance;
    }

    public void newInstance() {
        Bootstrapper.main(sargs);
    }

    public static enum TLauncherState {
        FULL,
        MINIMAL;

    }
}

