/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.component;

import com.turikhay.tlauncher.component.RefreshableComponent;

public abstract class InterruptibleComponent
extends RefreshableComponent {
    protected final boolean[] refreshList;
    protected int lastRefreshID;

    public InterruptibleComponent() {
        this(64);
    }

    public InterruptibleComponent(int listSize) {
        if (listSize < 1) {
            throw new IllegalArgumentException("Invalid list size: " + listSize + " < 1");
        }
        this.refreshList = new boolean[listSize];
    }

    public boolean startRefresh() {
        return this.refresh(this.nextID());
    }

    @Override
    protected boolean refresh() {
        return this.startRefresh();
    }

    public synchronized void stopRefresh() {
        int i = 0;
        while (i < this.refreshList.length) {
            this.refreshList[i] = false;
            ++i;
        }
    }

    protected synchronized int nextID() {
        int next;
        int listSize = this.refreshList.length;
        if ((next = this.lastRefreshID++) >= listSize) {
            next = 0;
        }
        this.lastRefreshID = next;
        return next;
    }

    protected boolean isCancelled(int refreshID) {
        return !this.refreshList[refreshID];
    }

    protected abstract boolean refresh(int var1);
}

