/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.component.managers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.turikhay.tlauncher.component.LauncherComponent;
import com.turikhay.tlauncher.component.managers.ComponentManager;
import com.turikhay.tlauncher.downloader.Downloadable;
import com.turikhay.tlauncher.downloader.DownloadableContainer;
import com.turikhay.tlauncher.minecraft.repository.AssetsRepository;
import com.turikhay.util.FileUtil;
import com.turikhay.util.U;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.launcher.updater.AssetIndex;
import net.minecraft.launcher.versions.CompleteVersion;
import org.apache.commons.io.IOUtils;

public class AssetsManager
implements LauncherComponent {
    private final ComponentManager manager;
    private final Gson gson;
    private final Object assetsFlushLock;

    public AssetsManager(ComponentManager manager) {
        this.manager = manager;
        this.gson = new Gson();
        this.assetsFlushLock = new Object();
    }

    public DownloadableContainer downloadResources(DownloadableContainer job, CompleteVersion version, List<AssetIndex.AssetObject> list, boolean force) throws IOException {
        File baseDirectory = this.manager.getVersionManager().getLocalList().getBaseDirectory();
        job.addAll(this.getResourceFiles(version, baseDirectory, list));
        return job;
    }

    private Set<Downloadable> getResourceFiles(CompleteVersion version, File baseDirectory, List<AssetIndex.AssetObject> list) {
        HashSet<Downloadable> result = new HashSet<Downloadable>();
        File objectsFolder = new File(baseDirectory, "assets/objects");
        for (AssetIndex.AssetObject object : list) {
            String filename = object.getFilename();
            String url = String.valueOf(AssetsRepository.DEFAULT.getSelectedRepo()) + filename;
            File file = new File(objectsFolder, filename);
            try {
                Downloadable d = new Downloadable(url, file, false);
                d.setFast(true);
                result.add(d);
            }
            catch (IOException e) {
                this.log("Cannot create downloadable resource from URL:", url, e);
            }
        }
        return result;
    }

    public List<AssetIndex.AssetObject> getResourceFiles(CompleteVersion version, File baseDirectory, boolean local) {
        List<AssetIndex.AssetObject> list = null;
        if (!local) {
            try {
                list = this.getRemoteResourceFilesList(version, baseDirectory, true);
            }
            catch (Exception e) {
                this.log("Cannot get remote assets list. Trying to use the local one.", e);
            }
        }
        if (list == null) {
            list = this.getLocalResourceFilesList(version, baseDirectory);
        }
        if (list == null) {
            try {
                list = this.getRemoteResourceFilesList(version, baseDirectory, true);
            }
            catch (Exception e) {
                this.log("Gave up trying to get assets list.", e);
            }
        }
        return list;
    }

    private List<AssetIndex.AssetObject> getLocalResourceFilesList(CompleteVersion version, File baseDirectory) {
        String json;
        ArrayList<AssetIndex.AssetObject> result = new ArrayList<AssetIndex.AssetObject>();
        String indexName = version.getAssets();
        File indexesFolder = new File(baseDirectory, "assets/indexes/");
        File indexFile = new File(indexesFolder, String.valueOf(indexName) + ".json");
        this.log("Reading indexes from file", indexFile);
        try {
            json = FileUtil.readFile(indexFile);
        }
        catch (Exception e) {
            this.log("Cannot read local resource files list for index:", indexName, e);
            return null;
        }
        AssetIndex index = null;
        try {
            index = this.gson.fromJson(json, AssetIndex.class);
        }
        catch (JsonSyntaxException e) {
            this.log("JSON file is invalid", e);
        }
        if (index == null) {
            this.log("Cannot read data from JSON file.");
            return null;
        }
        for (AssetIndex.AssetObject object : index.getUniqueObjects()) {
            result.add(object);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AssetIndex.AssetObject> getRemoteResourceFilesList(CompleteVersion version, File baseDirectory, boolean save) throws IOException {
        ArrayList<AssetIndex.AssetObject> result = new ArrayList<AssetIndex.AssetObject>();
        String indexName = version.getAssets();
        if (indexName == null) {
            indexName = "legacy";
        }
        File assets = new File(baseDirectory, "assets");
        File indexesFolder = new File(assets, "indexes");
        File indexFile = new File(indexesFolder, String.valueOf(indexName) + ".json");
        URL indexUrl = new URL("https://s3.amazonaws.com/Minecraft.Download/indexes/" + indexName + ".json");
        InputStream inputStream = indexUrl.openStream();
        this.log("Reading indexes from URL", indexUrl);
        String json = IOUtils.toString(inputStream);
        if (save) {
            Object object = this.assetsFlushLock;
            synchronized (object) {
                FileUtil.writeFile(indexFile, json);
            }
        }
        AssetIndex index = this.gson.fromJson(json, AssetIndex.class);
        for (AssetIndex.AssetObject object : index.getUniqueObjects()) {
            result.add(object);
        }
        return result;
    }

    public List<AssetIndex.AssetObject> checkResources(CompleteVersion version, File baseDirectory, boolean local, boolean fast) {
        this.log("Checking resources...");
        ArrayList<AssetIndex.AssetObject> r = new ArrayList<AssetIndex.AssetObject>();
        List<AssetIndex.AssetObject> list = local ? this.getLocalResourceFilesList(version, baseDirectory) : this.getResourceFiles(version, baseDirectory, true);
        if (list == null) {
            this.log("Cannot get assets list. Aborting.");
            return r;
        }
        this.log("Fast comparing:", fast);
        for (AssetIndex.AssetObject resource : list) {
            if (this.checkResource(baseDirectory, resource, fast)) continue;
            r.add(resource);
        }
        return r;
    }

    public List<AssetIndex.AssetObject> checkResources(CompleteVersion version, boolean fast) {
        return this.checkResources(version, this.manager.getVersionLists().getLocal().getBaseDirectory(), false, fast);
    }

    private boolean checkResource(File baseDirectory, AssetIndex.AssetObject local, boolean fast) {
        String path = local.getFilename();
        File file = new File(baseDirectory, "assets/objects/" + path);
        long size = file.length();
        if (!file.isFile() || size == 0L) {
            return false;
        }
        if (fast) {
            return true;
        }
        if (local.getSize() != size) {
            return false;
        }
        if (local.getHash() == null) {
            return true;
        }
        return local.getHash().equals(FileUtil.getChecksum(file, "SHA-1"));
    }

    protected void log(Object ... w) {
        U.log("[" + this.getClass().getSimpleName() + "]", w);
    }
}

