/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.component.managers;

import com.turikhay.tlauncher.component.InterruptibleComponent;
import com.turikhay.tlauncher.component.LauncherComponent;
import com.turikhay.tlauncher.component.RefreshableComponent;
import com.turikhay.tlauncher.component.managers.AssetsManager;
import com.turikhay.tlauncher.component.managers.ComponentManagerListener;
import com.turikhay.tlauncher.component.managers.ComponentManagerListenerHelper;
import com.turikhay.tlauncher.component.managers.ProfileManager;
import com.turikhay.tlauncher.component.managers.ServerListManager;
import com.turikhay.tlauncher.component.managers.VersionLists;
import com.turikhay.tlauncher.component.managers.VersionManager;
import com.turikhay.util.async.AsyncThread;

public class ComponentManager {
    private final VersionLists versionLists = new VersionLists();
    private final VersionManager versionManager = new VersionManager(this);
    private final AssetsManager assetsManager = new AssetsManager(this);
    private final ProfileManager profileManager = new ProfileManager();
    private final ComponentManagerListenerHelper listenerHelper = new ComponentManagerListenerHelper(this);
    private final LauncherComponent[] components = new LauncherComponent[]{this.versionManager, this.assetsManager, this.profileManager};

    public void addListener(ComponentManagerListener listener) {
        this.listenerHelper.addListener(listener);
    }

    public VersionLists getVersionLists() {
        return this.versionLists;
    }

    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    public AssetsManager getAssetsManager() {
        return this.assetsManager;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public ServerListManager getServerListManager() {
        return null;
    }

    public LauncherComponent[] getComponents() {
        return this.components;
    }

    public void startAsyncRefresh() {
        LauncherComponent[] launcherComponentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            LauncherComponent component = launcherComponentArray[n2];
            if (component instanceof RefreshableComponent) {
                final RefreshableComponent interruptible = (RefreshableComponent)component;
                AsyncThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        interruptible.refreshComponent();
                    }
                });
            }
            ++n2;
        }
    }

    public void startRefresh() {
        LauncherComponent[] launcherComponentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            LauncherComponent component = launcherComponentArray[n2];
            if (component instanceof RefreshableComponent) {
                RefreshableComponent interruptible = (RefreshableComponent)component;
                interruptible.refreshComponent();
            }
            ++n2;
        }
    }

    public void stopRefresh() {
        LauncherComponent[] launcherComponentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            LauncherComponent component = launcherComponentArray[n2];
            if (component instanceof InterruptibleComponent) {
                InterruptibleComponent interruptible = (InterruptibleComponent)component;
                interruptible.stopRefresh();
            }
            ++n2;
        }
    }

    public boolean contains(Class<?> componentClass) {
        if (componentClass == null) {
            throw new NullPointerException();
        }
        LauncherComponent[] launcherComponentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            LauncherComponent component = launcherComponentArray[n2];
            if (component.getClass().equals(componentClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

