/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.component.managers;

import com.turikhay.tlauncher.component.managers.ComponentManager;
import com.turikhay.tlauncher.component.managers.ComponentManagerListener;
import com.turikhay.tlauncher.component.managers.VersionManager;
import com.turikhay.tlauncher.component.managers.VersionManagerListener;
import com.turikhay.tlauncher.ui.block.Blockable;
import com.turikhay.tlauncher.ui.block.Blocker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ComponentManagerListenerHelper
implements Blockable,
VersionManagerListener {
    private final ComponentManager manager;
    private final List<ComponentManagerListener> listeners;

    ComponentManagerListenerHelper(ComponentManager manager) {
        this.manager = manager;
        this.listeners = Collections.synchronizedList(new ArrayList());
        manager.getVersionManager().addListener(this);
    }

    public void addListener(ComponentManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    @Override
    public void onVersionsRefreshing(VersionManager manager) {
        Blocker.block(this, manager);
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager manager) {
        Blocker.unblock(this, manager);
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        Blocker.unblock(this, manager);
    }

    @Override
    public void block(Object reason) {
        for (ComponentManagerListener listener : this.listeners) {
            listener.onComponentsRefreshing(this.manager);
        }
    }

    @Override
    public void unblock(Object reason) {
        for (ComponentManagerListener listener : this.listeners) {
            listener.onComponentsRefreshed(this.manager);
        }
    }
}

