/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.component.managers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.common.CompressedStreamTools;
import net.minecraft.common.NBTTagCompound;
import net.minecraft.common.NBTTagList;

public class ServerList {
    private List<Server> list = new ArrayList<Server>();

    public void add(Server server) {
        if (server == null) {
            throw new NullPointerException();
        }
        this.list.add(server);
    }

    public boolean remove(Server server) {
        if (server == null) {
            throw new NullPointerException();
        }
        return this.list.remove(server);
    }

    public boolean contains(Server server) {
        return this.list.contains(server);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public List<Server> getList() {
        return Collections.unmodifiableList(this.list);
    }

    public void save(File file) throws IOException {
        NBTTagList servers = new NBTTagList();
        for (Server server : this.list) {
            servers.appendTag(server.getNBT());
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.setTag("servers", servers);
        CompressedStreamTools.safeWrite(compound, file);
    }

    public String toString() {
        return "ServerList{" + this.list.toString() + "}";
    }

    public static ServerList loadFromFile(File file) throws IOException {
        ServerList serverList = new ServerList();
        List<Server> list = serverList.list;
        NBTTagCompound compound = CompressedStreamTools.read(file);
        if (compound == null) {
            return serverList;
        }
        NBTTagList servers = compound.getTagList("servers");
        int i = 0;
        while (i < servers.tagCount()) {
            list.add(Server.loadFromNBT((NBTTagCompound)servers.tagAt(i)));
            ++i;
        }
        return serverList;
    }

    public static ServerList sortLists(ServerList pref, ServerList add) {
        ServerList serverList = new ServerList();
        List<Server> list = serverList.list;
        List<Server> prefList = pref.list;
        List<Server> addList = add.list;
        serverList.list.addAll(prefList);
        for (Server server : addList) {
            if (list.contains(server)) continue;
            list.add(server);
        }
        return serverList;
    }

    public static class Server {
        private String name;
        private String version;
        private String address;
        private boolean hideAddress;
        private int acceptTextures;

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getAddress() {
            return this.address;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Server)) {
                return false;
            }
            Server server = (Server)obj;
            return server.address.equals(this.address);
        }

        public String toString() {
            return "{'" + this.name + "', '" + this.address + "', '" + this.version + "'}";
        }

        public static Server loadFromNBT(NBTTagCompound nbt) {
            Server server = new Server();
            server.name = nbt.getString("name");
            server.address = nbt.getString("ip");
            server.hideAddress = nbt.getBoolean("hideAddress");
            if (nbt.hasKey("acceptTextures")) {
                server.acceptTextures = nbt.getBoolean("acceptTextures") ? 1 : -1;
            }
            return server;
        }

        public NBTTagCompound getNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.setString("name", this.name);
            compound.setString("ip", this.address);
            compound.setBoolean("hideAddress", this.hideAddress);
            if (this.acceptTextures != 0) {
                compound.setBoolean("acceptTextures", this.acceptTextures == 1);
            }
            return compound;
        }
    }
}

