/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.configuration;

import com.turikhay.tlauncher.configuration.AbstractConfiguration;
import com.turikhay.util.StringUtil;
import com.turikhay.util.U;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SimpleConfiguration
implements AbstractConfiguration {
    protected final Properties properties = new Properties();
    protected Object input;
    protected String comments;

    public SimpleConfiguration() {
    }

    public SimpleConfiguration(InputStream stream) throws IOException {
        this();
        SimpleConfiguration.loadFromStream(this.properties, stream);
        this.input = stream;
    }

    public SimpleConfiguration(File file) {
        this();
        try {
            SimpleConfiguration.loadFromFile(this.properties, file);
        }
        catch (Exception e) {
            this.log("Error loading config from file:", e);
        }
        this.input = file;
    }

    public SimpleConfiguration(URL url) throws IOException {
        this();
        SimpleConfiguration.loadFromURL(this.properties, url);
        this.input = url;
    }

    @Override
    public String get(String key) {
        return SimpleConfiguration.getStringOf(this.properties.getProperty(key));
    }

    protected static String getStringOf(Object obj) {
        String s;
        if (obj == null) {
            s = null;
        } else {
            s = obj.toString();
            if (s.isEmpty()) {
                s = null;
            }
        }
        return s;
    }

    public void set(String key, Object value, boolean flush) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.setProperty(key, value.toString());
        }
        if (flush && this.isSaveable()) {
            this.store();
        }
    }

    @Override
    public void set(String key, Object value) {
        this.set(key, value, true);
    }

    public void set(Map<String, Object> map, boolean flush) {
        for (Map.Entry<String, Object> en : map.entrySet()) {
            String key = en.getKey();
            Object value = en.getValue();
            if (value == null) {
                this.properties.remove(key);
                continue;
            }
            this.properties.setProperty(key, value.toString());
        }
        if (flush && this.isSaveable()) {
            this.store();
        }
    }

    public void set(Map<String, Object> map) {
        this.set(map, false);
    }

    public Set<String> getKeys() {
        HashSet<String> set = new HashSet<String>();
        for (Object obj : this.properties.keySet()) {
            set.add(SimpleConfiguration.getStringOf(obj));
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public String getDefault(String key) {
        return null;
    }

    public int getInteger(String key, int def) {
        return SimpleConfiguration.getIntegerOf(this.get(key), 0);
    }

    @Override
    public int getInteger(String key) {
        return this.getInteger(key, 0);
    }

    protected static int getIntegerOf(Object obj, int def) {
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (Exception e) {
            return def;
        }
    }

    @Override
    public double getDouble(String key) {
        return SimpleConfiguration.getDoubleOf(this.get(key), 0.0);
    }

    protected static double getDoubleOf(Object obj, double def) {
        try {
            return Double.parseDouble(obj.toString());
        }
        catch (Exception e) {
            return def;
        }
    }

    @Override
    public float getFloat(String key) {
        return SimpleConfiguration.getFloatOf(this.get(key), 0.0f);
    }

    protected static float getFloatOf(Object obj, float def) {
        try {
            return Float.parseFloat(obj.toString());
        }
        catch (Exception e) {
            return def;
        }
    }

    @Override
    public long getLong(String key) {
        return SimpleConfiguration.getLongOf(this.get(key), 0L);
    }

    protected static long getLongOf(Object obj, long def) {
        try {
            return Long.parseLong(obj.toString());
        }
        catch (Exception e) {
            return def;
        }
    }

    @Override
    public boolean getBoolean(String key) {
        return SimpleConfiguration.getBooleanOf(this.get(key), false);
    }

    protected static boolean getBooleanOf(Object obj, boolean def) {
        try {
            return StringUtil.parseBoolean(obj.toString());
        }
        catch (Exception e) {
            return def;
        }
    }

    @Override
    public int getDefaultInteger(String key) {
        return 0;
    }

    @Override
    public double getDefaultDouble(String key) {
        return 0.0;
    }

    @Override
    public float getDefaultFloat(String key) {
        return 0.0f;
    }

    @Override
    public long getDefaultLong(String key) {
        return 0L;
    }

    @Override
    public boolean getDefaultBoolean(String key) {
        return false;
    }

    @Override
    public void save() throws IOException {
        if (!this.isSaveable()) {
            throw new UnsupportedOperationException();
        }
        File file = (File)this.input;
        this.properties.store(new FileOutputStream(file), this.comments);
    }

    public void store() {
        try {
            this.save();
        }
        catch (IOException e) {
            this.log("Cannot store values!", e);
        }
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    public boolean isSaveable() {
        return this.input != null && this.input instanceof File;
    }

    protected static void loadFromStream(Properties properties, InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException();
        }
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(stream), Charset.forName("UTF-8"));
        properties.clear();
        properties.load(reader);
    }

    protected static Properties loadFromStream(InputStream stream) throws IOException {
        Properties properties = new Properties();
        SimpleConfiguration.loadFromStream(properties, stream);
        return properties;
    }

    protected static void loadFromFile(Properties properties, File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        FileInputStream stream = new FileInputStream(file);
        SimpleConfiguration.loadFromStream(properties, stream);
    }

    protected static Properties loadFromFile(File file) throws IOException {
        Properties properties = new Properties();
        SimpleConfiguration.loadFromFile(properties, file);
        return properties;
    }

    protected static void loadFromURL(Properties properties, URL url) throws IOException {
        if (url == null) {
            throw new NullPointerException();
        }
        InputStream connection = url.openStream();
        SimpleConfiguration.loadFromStream(properties, connection);
    }

    protected static Properties loadFromURL(URL url) throws IOException {
        Properties properties = new Properties();
        SimpleConfiguration.loadFromURL(properties, url);
        return properties;
    }

    protected static void copyProperties(Properties src, Properties dest, boolean wipe) {
        if (src == null) {
            throw new NullPointerException("src is NULL");
        }
        if (dest == null) {
            throw new NullPointerException("dest is NULL");
        }
        if (wipe) {
            dest.clear();
        }
        for (Map.Entry<Object, Object> en : src.entrySet()) {
            String key = en.getKey() == null ? null : en.getKey().toString();
            String value = en.getKey() == null ? null : en.getValue().toString();
            dest.setProperty(key, value);
        }
    }

    protected static Properties copyProperties(Properties src) {
        Properties properties = new Properties();
        SimpleConfiguration.copyProperties(src, properties, false);
        return properties;
    }

    protected void log(Object ... o) {
        U.log("[" + this.getClass().getSimpleName() + "]", o);
    }
}

