/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.minecraft.auth;

import com.turikhay.tlauncher.minecraft.auth.Authenticator;
import com.turikhay.tlauncher.minecraft.auth.GameProfile;
import com.turikhay.tlauncher.minecraft.auth.User;
import com.turikhay.tlauncher.minecraft.auth.UserProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Account {
    protected String username;
    protected String userID;
    protected String displayName;
    protected String password;
    protected String accessToken;
    protected String uuid;
    protected List<Map<String, String>> userProperties;
    protected AccountType type = AccountType.PIRATE;
    protected GameProfile[] profiles;
    protected GameProfile selectedProfile;
    protected User user;
    private final Authenticator auth = new Authenticator(this);

    public Account() {
    }

    public Account(String username) {
        this();
        this.setUsername(username);
    }

    public Account(Map<String, Object> map) {
        this();
        this.fillFromMap(map);
    }

    public String getUsername() {
        return this.username;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        if (password != null) {
            this.type = AccountType.LICENSE;
        }
    }

    public void setPassword(char[] password) {
        this.setPassword(new String(password));
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        if ("null".equals(accessToken)) {
            accessToken = null;
        }
        this.accessToken = accessToken;
        this.type = accessToken == null ? AccountType.PIRATE : AccountType.LICENSE;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public GameProfile[] getProfiles() {
        return this.profiles;
    }

    public void setProfiles(GameProfile[] p) {
        this.profiles = p;
    }

    public GameProfile getProfile() {
        return this.selectedProfile != null ? this.selectedProfile : GameProfile.DEFAULT_PROFILE;
    }

    public void setProfile(GameProfile p) {
        this.selectedProfile = p;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        if (user == null) {
            throw new NullPointerException();
        }
        this.user = user;
    }

    public Map<String, List<String>> getProperties() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<UserProperty> list = new ArrayList<UserProperty>();
        if (this.userProperties != null) {
            for (Map<String, String> properties : this.userProperties) {
                list.add(new UserProperty(properties.get("name"), properties.get("value")));
            }
        }
        if (this.user != null && this.user.getProperties() != null) {
            for (Map<String, String> properties : this.user.getProperties()) {
                list.add(new UserProperty(properties.get("name"), properties.get("value")));
            }
        }
        for (UserProperty property : list) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(property.getValue());
            map.put(property.getKey(), values);
        }
        return map;
    }

    public void setProperties(List<Map<String, String>> properties) {
        this.userProperties = properties;
    }

    public AccountType getType() {
        return this.type;
    }

    public void setType(AccountType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
    }

    public boolean hasLicense() {
        return this.type.equals((Object)AccountType.LICENSE);
    }

    public void setHasLicense(boolean has) {
        this.setType(has ? AccountType.LICENSE : AccountType.PIRATE);
    }

    public Authenticator getAuthenticator() {
        return this.auth;
    }

    public Map<String, Object> createMap() {
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("username", this.username);
        r.put("userid", this.userID);
        r.put("uuid", this.uuid);
        r.put("displayName", this.displayName);
        if (this.hasLicense()) {
            r.put("accessToken", this.accessToken);
        }
        if (this.userProperties != null) {
            r.put("userProperties", this.userProperties);
        }
        return r;
    }

    public void fillFromMap(Map<String, Object> map) {
        if (map.containsKey("username")) {
            this.setUsername(map.get("username").toString());
        }
        this.setUserID(map.containsKey("userid") ? map.get("userid").toString() : this.getUsername());
        this.setDisplayName(map.containsKey("displayName") ? map.get("displayName").toString() : this.getUsername());
        this.setProperties(map.containsKey("userProperties") ? (List)map.get("userProperties") : null);
        this.setUUID(map.containsKey("uuid") ? map.get("uuid").toString() : null);
        this.setAccessToken(map.containsKey("accessToken") ? map.get("accessToken").toString() : null);
    }

    public void complete(Account acc) {
        if (acc == null) {
            throw new NullPointerException();
        }
        boolean sameName = acc.username.equals(this.username);
        this.username = acc.username;
        this.type = acc.type;
        if (acc.userID != null) {
            this.userID = acc.userID;
        }
        if (acc.displayName != null) {
            this.displayName = acc.displayName;
        }
        if (acc.password != null) {
            this.password = acc.password;
        }
        if (!sameName) {
            this.accessToken = null;
        }
    }

    public boolean equals(Account acc) {
        boolean pass;
        if (acc == null) {
            return false;
        }
        if (this.username == null) {
            return acc.username == null;
        }
        boolean bl = pass = this.password != null ? this.password.equals(acc.password) : true;
        return this.username.equals(acc.username) && this.type.equals((Object)acc.type) && pass;
    }

    public String toString() {
        if (this.username == null) {
            return "...";
        }
        return String.valueOf(this.username) + (this.displayName != null && this.hasLicense() ? " (" + this.displayName + ")" : "");
    }

    public static Account randomAccount() {
        return new Account("random" + new Random().nextLong());
    }

    public static enum AccountType {
        LICENSE,
        PIRATE;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

