/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.minecraft.launcher;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.component.managers.ComponentManager;
import com.turikhay.tlauncher.component.managers.ProfileManager;
import com.turikhay.tlauncher.component.managers.VersionManager;
import com.turikhay.tlauncher.configuration.Configuration;
import com.turikhay.tlauncher.downloader.DownloadableContainer;
import com.turikhay.tlauncher.minecraft.auth.Account;
import com.turikhay.tlauncher.minecraft.launcher.MinecraftListener;
import com.turikhay.tlauncher.ui.console.Console;
import com.turikhay.util.U;
import com.turikhay.util.logger.LinkedStringStream;
import com.turikhay.util.logger.PrintLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.process.JavaProcessLauncher;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;

public class MinecraftLauncher {
    public static final int OFFICIAL_VERSION = 14;
    public static final int ALTERNATIVE_VERSION = 6;
    public static final byte NONE = 0;
    public static final byte COLLECTING = 1;
    public static final byte DOWNLOADING = 2;
    public static final byte CONSTRUCTING = 3;
    public static final byte LAUNCHING = 4;
    public static final byte POSTLAUNCH = 5;
    private final ComponentManager manager;
    private final Configuration settings;
    private final VersionManager vm;
    private final ProfileManager pm;
    private final LinkedStringStream output;
    private final PrintLogger logger;
    private final Console console;
    private final List<MinecraftListener> listeners;
    private byte step;
    private String versionName;
    private VersionSyncInfo version;
    private CompleteVersion latestVersion;
    private String accountName;
    private Account account;
    private DownloadableContainer assetsContainer;
    private DownloadableContainer execContainer;
    private boolean downloadFlag;
    private File gameDir;
    private File assetsDir;
    private File nativeDir;
    private JavaProcessLauncher process;

    public MinecraftLauncher(ComponentManager manager, Configuration configuration) {
        if (manager == null) {
            throw new NullPointerException("Ti ohuel?");
        }
        if (configuration == null) {
            throw new NullPointerException("Configuration is NULL!");
        }
        this.settings = configuration;
        this.manager = manager;
        this.vm = manager.getVersionManager();
        this.pm = manager.getProfileManager();
        this.output = new LinkedStringStream();
        this.logger = new PrintLogger(this.output);
        this.console = new Console(this.settings, this.logger, "Minecraft Logger", false);
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.step = 0;
        this.log("Minecraft Launcher [14;6] has initialized");
        this.log("Running under TLauncher " + TLauncher.getVersion() + " " + TLauncher.getBrand());
        this.log("Current machine:", OperatingSystem.getCurrentInfo());
    }

    public void addListener(MinecraftListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    /*
     * Unable to fully structure code
     */
    public void start() {
        block4: {
            if (this.step > 0) {
                throw new IllegalStateException("MinecraftLauncher is already working!");
            }
            try {
                this.executeStep((byte)1);
                break block4;
            }
            catch (Throwable e) {
                ** for (listener : this.listeners)
            }
lbl-1000:
            // 1 sources

            {
                listener.onMinecraftError(e);
                continue;
            }
lbl10:
            // 1 sources

            this.step = 0;
        }
    }

    private void executeStep(byte step) throws Throwable {
        if (step == 0) {
            throw new IllegalArgumentException("Cannot execute empty step (" + step + "). Minimal:" + 1);
        }
        if (step > 5) {
            throw new IllegalArgumentException("Specified step is out of bounds (" + step + "). Maximal:" + 5);
        }
        switch (step) {
            case 0: {
                throw new IllegalArgumentException("Cannot execute empty step (" + step + "). Minimal:" + 1);
            }
            case 1: {
                this.collectInfo();
            }
            case 2: {
                this.downloadResources();
            }
            case 3: {
                this.constructProcess();
            }
            case 4: {
                this.launchMinecraft();
                break;
            }
            case 5: {
                this.postLaunch();
            }
        }
    }

    private void nextStep() throws Throwable {
        this.step = (byte)(this.step + 1);
        if (this.step > 5) {
            this.step = 1;
        }
        this.executeStep(this.step);
    }

    private void collectInfo() {
        this.step = 1;
        this.log("Collecting info:");
    }

    private void downloadResources() {
        this.step = (byte)2;
    }

    private void constructProcess() {
        this.step = (byte)3;
        this.log("Constructing process:");
    }

    private void launchMinecraft() {
        this.step = (byte)4;
        this.log("Launching Minecraft:");
    }

    private void postLaunch() {
        this.step = (byte)5;
        this.log("Post-launch step:");
    }

    protected void log(Object ... o) {
        U.log("[" + this.getClass().getSimpleName() + "]", o);
    }
}

