/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.minecraft.repository;

import com.turikhay.util.Time;
import com.turikhay.util.U;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.launcher.Http;

public class Repository {
    public static final int DEFAULT_TIMEOUT = 5000;
    public final String name;
    public final List<String> repos;
    private int primaryTimeout;
    private int selected;
    private boolean isSelected;

    public Repository(String name, int timeout, String[] urls) {
        if (name == null) {
            throw new NullPointerException("Name is NULL!");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name is empty!");
        }
        if (urls == null) {
            throw new NullPointerException("URL array is NULL!");
        }
        this.name = name.toUpperCase();
        this.repos = new ArrayList<String>();
        this.setTimeout(timeout);
        Collections.addAll(this.repos, urls);
        this.log("Repository has been created:", this.repos);
    }

    public Repository(String name, String[] urls) {
        this(name, 5000, urls);
    }

    public Repository(String name, int timeout) {
        this(name, timeout, new String[0]);
    }

    public Repository(String name) {
        this(name, 5000);
    }

    public int getTimeout() {
        return this.primaryTimeout;
    }

    public int getSelected() {
        return this.selected;
    }

    public void setSelected(int pos) {
        if (!this.isSelectable()) {
            throw new IllegalStateException();
        }
        this.isSelected = true;
        this.selected = pos;
    }

    public String getSelectedRepo() {
        return this.repos.get(this.selected);
    }

    public String getRepo(int pos) {
        return this.repos.get(pos);
    }

    public List<String> getList() {
        return this.repos;
    }

    public int getCount() {
        return this.repos.size();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isSelectable() {
        return !this.repos.isEmpty();
    }

    public String getUrl(String uri, boolean selectPath) throws IOException {
        boolean canSelect = this.isSelectable();
        if (!canSelect) {
            return this.getRawUrl(uri);
        }
        boolean gotError = false;
        if (!selectPath && this.isSelected()) {
            try {
                return this.getRawUrl(uri);
            }
            catch (IOException e) {
                gotError = true;
                this.log("Cannot get required URL, reselecting path.");
            }
        }
        this.log("Selecting relevant path...");
        Object lock = new Object();
        IOException e = null;
        int i = 0;
        int attempt = 0;
        int exclude = gotError ? this.getSelected() : -1;
        while (i < 3) {
            int timeout = this.primaryTimeout * ++i;
            int x = 0;
            while (x < this.getCount()) {
                if (i != 1 || x != exclude) {
                    this.log("Attempt #" + ++attempt + "; timeout: " + timeout + " ms; url: " + this.getRepo(x));
                    Time.start(lock);
                    try {
                        String result = Http.performGet(new URL(String.valueOf(this.getRepo(x)) + uri), timeout, timeout);
                        this.setSelected(x);
                        this.log("Success: Reached the repo in", Time.stop(lock), "ms.");
                        return result;
                    }
                    catch (IOException e0) {
                        this.log("Failed: Repo is not reachable!");
                        e = e0;
                        Time.stop(lock);
                    }
                }
                ++x;
            }
        }
        this.log("Failed: All repos are unreachable.");
        throw e;
    }

    public String getUrl(String uri) throws IOException {
        return this.getUrl(uri, false);
    }

    public String getUrl() throws IOException {
        return this.getUrl("", false);
    }

    public String getRawUrl(String uri) throws IOException {
        String url = String.valueOf(this.getSelectedRepo()) + Http.encode(uri);
        try {
            return Http.performGet(new URL(url));
        }
        catch (IOException e) {
            this.log("Cannot get raw:", url);
            throw e;
        }
    }

    public String toString() {
        return this.name.toLowerCase();
    }

    public void setTimeout(int ms) {
        if (ms < 0) {
            throw new IllegalArgumentException("Negative timeout: " + ms);
        }
        this.primaryTimeout = ms;
    }

    protected void log(Object ... obj) {
        U.log("[REPO][" + this.name + "]", obj);
    }
}

