/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.accounts;

import com.turikhay.tlauncher.minecraft.auth.Account;
import com.turikhay.tlauncher.ui.accounts.UsernameField;
import com.turikhay.tlauncher.ui.center.CenterPanel;
import com.turikhay.tlauncher.ui.loc.LocalizableButton;
import com.turikhay.tlauncher.ui.loc.LocalizableCheckbox;
import com.turikhay.tlauncher.ui.progress.ProgressBar;
import com.turikhay.tlauncher.ui.scenes.AccountEditorScene;
import com.turikhay.tlauncher.ui.swing.CheckBoxListener;
import com.turikhay.tlauncher.ui.text.ExtendedPasswordField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class AccountEditor
extends CenterPanel {
    private static final long serialVersionUID = 7061277150214976212L;
    private final AccountEditorScene scene;
    public final UsernameField username;
    public final ExtendedPasswordField password;
    public final LocalizableCheckbox premiumBox;
    public final LocalizableButton save;
    public final ProgressBar progressBar;

    public AccountEditor(AccountEditorScene sc) {
        super(squareInsets);
        this.scene = sc;
        this.username = new UsernameField((CenterPanel)this, UsernameField.UsernameState.USERNAME);
        this.password = new ExtendedPasswordField();
        this.password.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountEditor.this.defocus();
                ((AccountEditor)AccountEditor.this).scene.handler.saveEditor();
            }
        });
        this.premiumBox = new LocalizableCheckbox("account.premium");
        this.premiumBox.addItemListener(new CheckBoxListener(){

            @Override
            public void itemStateChanged(boolean newstate) {
                if (newstate && !AccountEditor.this.password.hasPassword()) {
                    AccountEditor.this.password.setText(null);
                }
                AccountEditor.this.password.setEnabled(newstate);
                AccountEditor.this.username.setState(newstate ? UsernameField.UsernameState.EMAIL : UsernameField.UsernameState.USERNAME);
                AccountEditor.this.defocus();
            }
        });
        this.save = new LocalizableButton("account.save");
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountEditor.this.defocus();
                ((AccountEditor)AccountEditor.this).scene.handler.saveEditor();
            }
        });
        this.progressBar = new ProgressBar();
        this.progressBar.setPreferredSize(new Dimension(200, 20));
        this.add((Component)this.del(0));
        this.add((Component)AccountEditor.sepPan(this.username));
        this.add((Component)AccountEditor.sepPan(this.premiumBox));
        this.add((Component)AccountEditor.sepPan(this.password));
        this.add((Component)this.del(0));
        this.add((Component)AccountEditor.sepPan(this.save));
        this.add((Component)AccountEditor.sepPan(this.progressBar));
    }

    public void fill(Account account) {
        this.premiumBox.setSelected(account.hasLicense());
        this.username.setText(account.getUsername());
        this.password.setText(null);
    }

    public void clear() {
        this.premiumBox.setSelected(false);
        this.username.setText(null);
        this.password.setText(null);
    }

    public Account get() {
        Account account = new Account();
        account.setUsername(this.username.getValue());
        if (this.premiumBox.isSelected()) {
            account.setHasLicense(true);
            if (this.password.hasPassword()) {
                account.setPassword(this.password.getPassword());
            }
        }
        return account;
    }

    @Override
    public Insets getInsets() {
        return squareInsets;
    }

    @Override
    public void block(Object reason) {
        super.block(reason);
        this.password.setEnabled(this.premiumBox.isSelected());
        if (!reason.equals("empty")) {
            this.progressBar.setIndeterminate(true);
        }
    }

    @Override
    public void unblock(Object reason) {
        super.unblock(reason);
        this.password.setEnabled(this.premiumBox.isSelected());
        if (!reason.equals("empty")) {
            this.progressBar.setIndeterminate(false);
        }
    }
}

