/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.accounts;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.component.managers.ProfileManager;
import com.turikhay.tlauncher.minecraft.auth.Account;
import com.turikhay.tlauncher.minecraft.auth.Authenticator;
import com.turikhay.tlauncher.minecraft.auth.AuthenticatorListener;
import com.turikhay.tlauncher.ui.accounts.AccountEditor;
import com.turikhay.tlauncher.ui.accounts.AccountList;
import com.turikhay.tlauncher.ui.accounts.helper.HelperState;
import com.turikhay.tlauncher.ui.alert.Alert;
import com.turikhay.tlauncher.ui.block.Blocker;
import com.turikhay.tlauncher.ui.listeners.AuthUIListener;
import com.turikhay.tlauncher.ui.scenes.AccountEditorScene;
import com.turikhay.util.U;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPopupMenu;

public class AccountHandler {
    public final AccountEditorScene scene;
    public final AccountList list;
    public final AccountEditor editor;
    private final ProfileManager manager = TLauncher.getInstance().getProfileManager();
    private final AuthUIListener listener;
    private Account lastAccount;
    private Account tempAccount;
    private JPopupMenu popup;

    public AccountHandler(AccountEditorScene sc) {
        this.scene = sc;
        this.list = this.scene.list;
        this.editor = this.scene.editor;
        this.popup = new JPopupMenu();
        HelperState[] helperStateArray = HelperState.values();
        int n = helperStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            final HelperState state = helperStateArray[n2];
            if (state.showInList) {
                state.item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AccountHandler.this.scene.helper.setState(state);
                    }
                });
                this.popup.add(state.item);
            }
            ++n2;
        }
        this.listener = new AuthUIListener(false, new AuthenticatorListener(){

            @Override
            public void onAuthPassing(Authenticator auth) {
                AccountHandler.this.block();
            }

            @Override
            public void onAuthPassingError(Authenticator auth, Throwable e) {
                AccountHandler.this.unblock();
            }

            @Override
            public void onAuthPassed(Authenticator auth) {
                AccountHandler.this.unblock();
                AccountHandler.this.registerTemp();
            }
        });
    }

    public void selectAccount(Account acc) {
        if (acc == null) {
            return;
        }
        if (acc.equals(this.list.list.getSelectedValue())) {
            return;
        }
        this.list.list.setSelectedValue(acc, true);
    }

    void refreshEditor(Account account) {
        if (account == null) {
            this.clearEditor();
            return;
        }
        if (account.equals(this.lastAccount)) {
            return;
        }
        this.lastAccount = account;
        Blocker.unblock(this.editor, "empty");
        this.editor.fill(account);
        if (!account.equals(this.tempAccount)) {
            this.scene.getMainPane().defaultScene.loginForm.accounts.setAccount(this.lastAccount);
        }
    }

    void clearEditor() {
        this.lastAccount = null;
        this.editor.clear();
        if (!this.list.model.isEmpty()) {
            this.list.list.setSelectedValue(this.lastAccount, true);
        }
    }

    void saveEditor() {
        if (this.lastAccount == null) {
            return;
        }
        Account acc = this.editor.get();
        if (acc.getUsername() == null) {
            Alert.showError("auth.error.nousername");
            return;
        }
        this.lastAccount.complete(acc);
        if (this.lastAccount.hasLicense()) {
            if (this.lastAccount.getAccessToken() == null && this.lastAccount.getPassword() == null) {
                Alert.showError("auth.error.nopass");
                return;
            }
            this.lastAccount.getAuthenticator().asyncPass(this.listener);
        } else {
            this.registerTemp();
            this.listener.saveProfiles();
        }
    }

    void exitEditor() {
        this.scene.getMainPane().openDefaultScene();
        this.listener.saveProfiles();
    }

    void addAccount() {
        if (this.tempAccount != null) {
            return;
        }
        this.tempAccount = new Account();
        this.list.model.addElement(this.tempAccount);
        this.list.list.setSelectedValue(this.tempAccount, true);
        this.refreshEditor(this.tempAccount);
    }

    void removeAccount() {
        if (this.lastAccount == null) {
            return;
        }
        Account acc = this.lastAccount;
        this.list.model.removeElement(this.lastAccount);
        this.lastAccount = acc;
        if (this.tempAccount != null) {
            this.tempAccount = null;
            this.clearEditor();
            return;
        }
        U.log("Removing", this.lastAccount);
        this.manager.getAuthDatabase().unregisterAccount(this.lastAccount);
        this.clearEditor();
        this.listener.saveProfiles();
    }

    void registerTemp() {
        if (this.tempAccount == null) {
            return;
        }
        this.manager.getAuthDatabase().registerAccount(this.tempAccount);
        this.scene.getMainPane().defaultScene.loginForm.accounts.refreshAccounts(this.manager.getAuthDatabase(), this.tempAccount.getUsername());
        this.tempAccount = null;
    }

    void notifyEmpty() {
        Blocker.block(this.editor, "empty");
        if (this.scene.helper.isShowing()) {
            this.scene.helper.setState(HelperState.HELP);
        }
    }

    void callPopup() {
        if (this.popup.isShowing()) {
            return;
        }
        this.popup.show(this.list.help, 0, this.list.help.getHeight());
    }

    private void block() {
        Blocker.block("auth", this.editor, this.list);
    }

    private void unblock() {
        Blocker.unblock("auth", this.editor, this.list);
    }
}

