/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.accounts.helper;

import com.turikhay.tlauncher.ui.MainPane;
import com.turikhay.tlauncher.ui.accounts.AccountHandler;
import com.turikhay.tlauncher.ui.accounts.helper.HelperState;
import com.turikhay.tlauncher.ui.accounts.helper.HelperStep;
import com.turikhay.tlauncher.ui.center.CenterPanel;
import com.turikhay.tlauncher.ui.loc.LocalizableLabel;
import com.turikhay.tlauncher.ui.scenes.AccountEditorScene;
import com.turikhay.tlauncher.ui.swing.extended.ExtendedLayeredPane;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.util.Arrays;
import javax.swing.JComponent;

public class AccountEditorHelper
extends ExtendedLayeredPane {
    private static final int MARGIN = 5;
    public static final byte LEFT = 0;
    public static final byte UP = 1;
    public static final byte RIGHT = 2;
    public static final byte DOWN = 3;
    private static final long serialVersionUID = -8240523754377261945L;
    private final AccountHandler handler;
    private final MainPane pane;
    private final HelperStep[] steps;
    private HelperState state;

    public AccountEditorHelper(AccountEditorScene scene) {
        super(scene);
        this.handler = scene.handler;
        this.pane = scene.getMainPane();
        this.steps = new HelperStep[]{new HelperStep("add", this.handler.list.add, this.handler.list, 3, HelperState.LICENSE, HelperState.PIRATE), new HelperStep("username", this.handler.editor.username, this.handler.editor, 0, HelperState.LICENSE, HelperState.PIRATE), new HelperStep("checkbox", this.handler.editor.premiumBox, this.handler.editor, 0, HelperState.LICENSE, HelperState.PIRATE), new HelperStep("password", this.handler.editor.password, this.handler.editor, 0, HelperState.LICENSE), new HelperStep("button", this.handler.editor.save, this.handler.editor, 0, HelperState.LICENSE, HelperState.PIRATE), new HelperStep("exit", this.handler.list.back, this.handler.list, 2, HelperState.LICENSE, HelperState.PIRATE), new HelperStep("help", this.handler.list.help, this.handler.list, 3, HelperState.HELP)};
        this.add(this.steps);
        this.setState(HelperState.NONE);
    }

    public HelperState getState() {
        return this.state;
    }

    public void updateState() {
        this.setState(this.state);
    }

    public void setState(HelperState state) {
        HelperState step;
        if (state == null) {
            throw new NullPointerException();
        }
        this.state = state;
        Object[] objectArray = HelperState.values();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            HelperState st = objectArray[n2];
            st.item.setEnabled(!st.equals((Object)state));
            ++n2;
        }
        if (state == HelperState.NONE) {
            objectArray = this.steps;
            n = this.steps.length;
            n2 = 0;
            while (n2 < n) {
                step = objectArray[n2];
                if (((Component)((Object)step)).isShowing()) {
                    ((JComponent)((Object)step)).setVisible(false);
                }
                ++n2;
            }
            return;
        }
        objectArray = this.steps;
        n = this.steps.length;
        n2 = 0;
        while (n2 < n) {
            step = objectArray[n2];
            if (Arrays.binarySearch((Object[])((HelperStep)((Object)step)).states, 0, ((HelperStep)((Object)step)).states.length, (Object)state) < 0) {
                ((JComponent)((Object)step)).setVisible(false);
            } else {
                int y;
                int x;
                LocalizableLabel l = ((HelperStep)((Object)step)).label;
                l.setText("auth.helper." + state.toString() + "." + ((HelperStep)((Object)step)).name);
                Component c = ((HelperStep)((Object)step)).component;
                int cWidth = c.getWidth();
                int cHeight = c.getHeight();
                Point cp = this.pane.getLocationOf(c);
                Component p = ((HelperStep)((Object)step)).parent;
                int pWidth = p.getWidth();
                int pHeight = p.getHeight();
                Point pp = this.pane.getLocationOf(p);
                FontMetrics fm = l.getFontMetrics(l.getFont());
                Insets i = ((CenterPanel)((Object)step)).getInsets();
                int height = i.top + i.bottom + fm.getHeight();
                int width = i.left + i.right + fm.stringWidth(l.getText());
                switch (((HelperStep)((Object)step)).alignment) {
                    case 0: {
                        x = pp.x - 5 - width;
                        y = cp.y + cHeight / 2 - height / 2;
                        break;
                    }
                    case 1: {
                        x = cp.x + cWidth / 2 - width / 2;
                        y = pp.y - 5 - height;
                        break;
                    }
                    case 2: {
                        x = pp.x + pWidth + 5;
                        y = cp.y + cHeight / 2 - height / 2;
                        break;
                    }
                    case 3: {
                        x = cp.x + cWidth / 2 - width / 2;
                        y = pp.y + pHeight + 5;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown alignment");
                    }
                }
                ((JComponent)((Object)step)).setVisible(true);
                ((Component)((Object)step)).setBounds(x, y, width, height);
            }
            ++n2;
        }
        this.setVisible(true);
    }

    @Override
    public void onResize() {
        super.onResize();
        this.updateState();
    }
}

