/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.console;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.configuration.Configuration;
import com.turikhay.tlauncher.ui.TLauncherFrame;
import com.turikhay.tlauncher.ui.console.ConsoleFrame;
import com.turikhay.tlauncher.ui.console.SearchPrefs;
import com.turikhay.util.StringUtil;
import com.turikhay.util.U;
import com.turikhay.util.async.AsyncThread;
import com.turikhay.util.logger.LinkedStringStream;
import com.turikhay.util.logger.Logger;
import com.turikhay.util.logger.PrintLogger;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Console
implements Logger {
    private static List<ConsoleFrame> frames = Collections.synchronizedList(new ArrayList());
    private final Configuration global;
    private final ConsoleFrame frame;
    private final String name;
    private LinkedStringStream stream;
    private PrintLogger logger;
    private CloseAction close;
    private boolean killed;

    public Console(Configuration global, PrintLogger logger, String name, boolean show) {
        this.global = global;
        this.name = name;
        TLauncherFrame.initLookAndFeel();
        this.frame = new ConsoleFrame(this, global, name);
        frames.add(this.frame);
        this.update();
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                Console.this.save();
                Console.this.onClose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.frame.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Console.this.save(false);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                Console.this.save(false);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                Console.this.save(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Console.this.save(true);
            }
        });
        if (logger == null) {
            this.logger = null;
            this.stream = new LinkedStringStream();
            this.stream.setLogger(this);
        } else {
            this.logger = logger;
            logger.setMirror(this);
            this.stream = logger.getStream();
        }
        if (show) {
            this.show();
        }
        if (this.stream.getLength() != 0) {
            this.rawlog(this.stream.getOutput());
        }
    }

    @Override
    public void log(String s) {
        if (this.logger != null) {
            this.logger.rawlog(s);
        } else {
            this.stream.write(s.toCharArray());
        }
    }

    @Override
    public void log(Object ... o) {
        this.log(U.toLog(o));
    }

    @Override
    public void rawlog(String s) {
        if (StringUtil.lastChar(s) == '\n') {
            this.frame.print(s);
        } else {
            this.frame.println(s);
        }
    }

    public void rawlog(Object ... o) {
        this.rawlog(U.toLog(o));
    }

    @Override
    public void rawlog(char[] c) {
        this.rawlog(new String(c));
    }

    public PrintLogger getLogger() {
        return this.logger;
    }

    public String getOutput() {
        return this.stream.getOutput();
    }

    public void update() {
        this.check();
        if (this.global == null) {
            return;
        }
        String prefix = "gui.console.";
        int width = this.global.getInteger(String.valueOf(prefix) + "width", 620);
        int height = this.global.getInteger(String.valueOf(prefix) + "height", 400);
        int x = this.global.getInteger(String.valueOf(prefix) + "x", 0);
        int y = this.global.getInteger(String.valueOf(prefix) + "y", 0);
        prefix = String.valueOf(prefix) + "search.";
        boolean mcase = this.global.getBoolean(String.valueOf(prefix) + "mcase");
        boolean whole = this.global.getBoolean(String.valueOf(prefix) + "whole");
        boolean cycle = this.global.getBoolean(String.valueOf(prefix) + "cycle");
        boolean regexp = this.global.getBoolean(String.valueOf(prefix) + "regexp");
        this.frame.setSize(width, height);
        this.frame.setLocation(x, y);
        SearchPrefs sf = this.frame.getSearchPrefs();
        sf.setCaseSensetive(mcase);
        sf.setWordSearch(whole);
        sf.setCycled(cycle);
        sf.setRegExp(regexp);
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean flush) {
        this.check();
        if (this.global == null) {
            return;
        }
        String prefix = "gui.console.";
        int[] size = this.getSize();
        int[] position = this.getPosition();
        this.global.set(String.valueOf(prefix) + "width", size[0], false);
        this.global.set(String.valueOf(prefix) + "height", size[1], false);
        this.global.set(String.valueOf(prefix) + "x", position[0], false);
        this.global.set(String.valueOf(prefix) + "y", position[1], false);
        prefix = String.valueOf(prefix) + "search.";
        boolean[] prefs = this.frame.getSearchPrefs().get();
        this.global.set(String.valueOf(prefix) + "mcase", prefs[0], false);
        this.global.set(String.valueOf(prefix) + "whole", prefs[1], false);
        this.global.set(String.valueOf(prefix) + "cycle", prefs[2], false);
        this.global.set(String.valueOf(prefix) + "regexp", prefs[3], flush);
    }

    private void check() {
        if (this.killed) {
            throw new IllegalStateException("Console is already killed!");
        }
    }

    public void setShown(boolean shown) {
        if (shown) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean toFront) {
        this.check();
        this.frame.setVisible(true);
        this.frame.scrollBottom();
        if (toFront) {
            this.frame.toFront();
        }
    }

    public void hide() {
        this.check();
        this.frame.setVisible(false);
    }

    public void clear() {
        this.check();
        this.frame.clear();
    }

    public void kill() {
        this.check();
        this.save();
        this.frame.setVisible(false);
        this.frame.clear();
        frames.remove(this.frame);
        this.killed = true;
    }

    public void killIn(long millis) {
        this.check();
        this.save();
        this.frame.hideIn(millis);
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                if (Console.this.isHidden()) {
                    Console.this.kill();
                }
            }
        }, millis + 1000L);
    }

    public boolean isKilled() {
        this.check();
        return this.killed;
    }

    public boolean isHidden() {
        this.check();
        return !this.frame.isShowing();
    }

    public String getName() {
        return this.name;
    }

    public Point getPositionPoint() {
        this.check();
        return this.frame.getLocation();
    }

    public int[] getPosition() {
        this.check();
        Point p = this.getPositionPoint();
        return new int[]{p.x, p.y};
    }

    public Dimension getDimension() {
        this.check();
        return this.frame.getSize();
    }

    public int[] getSize() {
        this.check();
        Dimension d = this.getDimension();
        return new int[]{d.width, d.height};
    }

    public CloseAction getCloseAction() {
        return this.close;
    }

    public void setCloseAction(CloseAction action) {
        this.close = action;
    }

    private void onClose() {
        if (this.close == null) {
            return;
        }
        switch (this.close) {
            case KILL: {
                this.kill();
            }
            case EXIT: {
                TLauncher.kill();
            }
        }
    }

    public static void updateLocale() {
        for (ConsoleFrame frame : frames) {
            frame.updateLocale();
        }
    }

    public static enum CloseAction {
        KILL,
        EXIT;

    }
}

