/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.console;

import com.turikhay.tlauncher.ui.block.Blockable;
import com.turikhay.tlauncher.ui.console.SearchPanel;
import com.turikhay.tlauncher.ui.images.ImageCache;
import com.turikhay.tlauncher.ui.swing.ImageButton;
import java.awt.AlphaComposite;
import java.awt.Button;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class SearchButton
extends Button
implements Blockable {
    private static final long serialVersionUID = 682875580116075167L;
    protected Image image;
    protected ImageButton.ImageRotation rotation = ImageButton.ImageRotation.CENTER;
    protected int margin = 4;
    private boolean pressed;

    SearchButton(final SearchPanel sp) {
        this.image = ImageCache.getImage("search.png");
        this.setForeground(Color.white);
        this.setBackground(Color.black);
        this.initListeners();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sp.search();
            }
        });
        this.setPreferredSize(new Dimension(50, this.getHeight()));
    }

    @Override
    public void update(Graphics g) {
        super.update(g);
        this.paint(g);
    }

    @Override
    public void paint(Graphics g0) {
        int twidth;
        super.paint(g0);
        if (this.image == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g0;
        String text = this.getLabel();
        boolean drawtext = text != null && text.length() > 0;
        FontMetrics fm = g.getFontMetrics();
        float opacity = this.isEnabled() ? 1.0f : 0.5f;
        int width = this.getWidth();
        int height = this.getHeight();
        int rmargin = this.margin;
        int offset = this.pressed ? 1 : 0;
        int iwidth = this.image.getWidth(null);
        int iheight = this.image.getHeight(null);
        int ix = 0;
        int iy = height / 2 - iheight / 2;
        if (drawtext) {
            twidth = fm.stringWidth(text);
        } else {
            rmargin = 0;
            twidth = 0;
        }
        switch (this.rotation) {
            case LEFT: {
                ix = width / 2 - twidth / 2 - iwidth - rmargin;
                break;
            }
            case CENTER: {
                ix = width / 2 - iwidth / 2;
                break;
            }
            case RIGHT: {
                ix = width / 2 + twidth / 2 + rmargin;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown rotation!");
            }
        }
        Composite c = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, opacity));
        g.drawImage(this.image, ix + offset, iy + offset, null);
        g.setComposite(c);
        this.pressed = false;
    }

    private void initListeners() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SearchButton.this.pressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 32) {
                    return;
                }
                SearchButton.this.pressed = true;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SearchButton.this.pressed = false;
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }
}

