/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.console;

import com.turikhay.tlauncher.ui.console.SearchPanel;
import com.turikhay.tlauncher.ui.loc.LocalizableCheckbox;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class SearchPrefs
extends JPanel {
    private static final long serialVersionUID = -5187427203445160236L;
    LocalizableCheckbox pcase;
    LocalizableCheckbox pwhole;
    LocalizableCheckbox pcycle;
    LocalizableCheckbox pregexp;

    SearchPrefs(SearchPanel sp) {
        BoxLayout layout = new BoxLayout(this, 2);
        this.setLayout(layout);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.pcase = new LocalizableCheckbox("console.search.prefs.case");
        this.add(this.pcase);
        this.pwhole = new LocalizableCheckbox("console.search.prefs.whole");
        this.add(this.pwhole);
        this.pcycle = new LocalizableCheckbox("console.search.prefs.cycle");
        this.add(this.pcycle);
        this.pregexp = new LocalizableCheckbox("console.search.prefs.regexp");
        this.add(this.pregexp);
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setForeground(Color.white);
            ++n2;
        }
    }

    public boolean isCaseSensetive() {
        return this.pcase.getState();
    }

    public boolean isWordSearch() {
        return this.pwhole.getState();
    }

    public boolean isCycled() {
        return this.pcycle.getState();
    }

    public boolean isRegExp() {
        return this.pregexp.getState();
    }

    public void setCaseSensetive(boolean s) {
        this.pcase.setState(s);
    }

    public void setWordSearch(boolean s) {
        this.pwhole.setState(s);
    }

    public void setCycled(boolean s) {
        this.pcycle.setState(s);
    }

    public void setRegExp(boolean s) {
        this.pregexp.setState(s);
    }

    public boolean[] get() {
        return new boolean[]{this.isCaseSensetive(), this.isWordSearch(), this.isCycled(), this.isRegExp()};
    }
}

