/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.images;

import com.turikhay.tlauncher.exceptions.TLauncherException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageCache {
    private static final Map<String, Image> imageCache = Collections.synchronizedMap(new HashMap());

    public static Image getImage(String uri) {
        return ImageCache.getImage(uri, true);
    }

    public static Image getImage(String uri, boolean throwIfError) {
        if (uri == null) {
            throw new NullPointerException("URL is NULL");
        }
        if (imageCache.containsKey(uri)) {
            return imageCache.get(uri);
        }
        try {
            BufferedImage image = ImageIO.read(ImageCache.getRes(uri));
            imageCache.put(uri, image);
            return image;
        }
        catch (Exception e) {
            if (throwIfError) {
                throw new TLauncherException("Cannot load required image:" + uri, e);
            }
            e.printStackTrace();
            return null;
        }
    }

    public static URL getRes(String uri) {
        return ImageCache.class.getResource(uri);
    }
}

