/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.loc;

import com.turikhay.tlauncher.ui.loc.Localizable;
import com.turikhay.tlauncher.ui.loc.LocalizableComponent;
import com.turikhay.tlauncher.ui.swing.extended.ExtendedLabel;

public class LocalizableLabel
extends ExtendedLabel
implements LocalizableComponent {
    private static final long serialVersionUID = 7628068160047735335L;
    private String path;
    private String[] variables;

    public LocalizableLabel(String path, Object ... vars) {
        this.setText(path, vars);
    }

    public LocalizableLabel(String path) {
        this(path, Localizable.EMPTY_VARS);
    }

    public LocalizableLabel() {
        this((String)null);
    }

    public LocalizableLabel(int horizontalAlignment) {
        this((String)null);
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public void setText(String path, Object ... vars) {
        this.path = path;
        this.variables = Localizable.checkVariables(vars);
        String value = Localizable.get(path);
        int i = 0;
        while (i < this.variables.length) {
            value = value.replace("%" + i, this.variables[i]);
            ++i;
        }
        super.setText(value);
    }

    @Override
    public void setText(String path) {
        this.setText(path, Localizable.EMPTY_VARS);
    }

    @Override
    public void updateLocale() {
        this.setText(this.path, this.variables);
    }
}

