/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.login;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.component.managers.ProfileManager;
import com.turikhay.tlauncher.component.managers.ProfileManagerListener;
import com.turikhay.tlauncher.minecraft.auth.Account;
import com.turikhay.tlauncher.minecraft.auth.AuthenticatorDatabase;
import com.turikhay.tlauncher.minecraft.auth.AuthenticatorListener;
import com.turikhay.tlauncher.ui.block.Blockable;
import com.turikhay.tlauncher.ui.listeners.AuthUIListener;
import com.turikhay.tlauncher.ui.loc.LocalizableComponent;
import com.turikhay.tlauncher.ui.login.LoginException;
import com.turikhay.tlauncher.ui.login.LoginForm;
import com.turikhay.tlauncher.ui.login.LoginListener;
import com.turikhay.tlauncher.ui.login.LoginWaitException;
import com.turikhay.tlauncher.ui.swing.AccountCellRenderer;
import com.turikhay.tlauncher.ui.swing.extended.ExtendedComboBox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;

public class AccountComboBox
extends ExtendedComboBox<Account>
implements Blockable,
LoginListener,
ProfileManagerListener,
LocalizableComponent {
    private static final long serialVersionUID = 6618039863712810645L;
    public static final Account EMPTY = AccountCellRenderer.EMPTY;
    public static final Account MANAGE = AccountCellRenderer.MANAGE;
    private final ProfileManager manager;
    private final LoginForm loginForm;
    private final AuthenticatorListener listener;
    private String selectedAccount;

    AccountComboBox(LoginForm lf) {
        super(new AccountCellRenderer());
        this.loginForm = lf;
        this.manager = TLauncher.getInstance().getProfileManager();
        this.manager.addListener(this);
        this.listener = new AuthUIListener(true, lf);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Account selected = (Account)AccountComboBox.this.getSelectedItem();
                if (selected == null) {
                    return;
                }
                if (selected.equals(EMPTY)) {
                    return;
                }
                if (selected.equals(MANAGE)) {
                    ((AccountComboBox)AccountComboBox.this).loginForm.pane.openAccountEditor();
                    AccountComboBox.this.setAccount(AccountComboBox.this.selectedAccount);
                    return;
                }
                AccountComboBox.this.selectedAccount = selected.getUsername();
            }
        });
        this.selectedAccount = lf.global.get("login.account");
    }

    public Account getAccount() {
        Account value = (Account)this.getSelectedItem();
        return value == null || value.equals(EMPTY) || value.equals(MANAGE) ? null : value;
    }

    public void setAccount(Account account) {
        if (account == null) {
            return;
        }
        if (account.equals(this.getAccount())) {
            return;
        }
        this.setSelectedItem(account);
    }

    public void setAccount(String username) {
        if (username != null) {
            this.setSelectedItem(this.manager.getAuthDatabase().getByUsername(username));
        }
    }

    @Override
    public void onLogin() throws LoginException {
        final Account account = this.getAccount();
        if (account == null) {
            this.loginForm.pane.openAccountEditor();
            throw new LoginException("Account list is empty!");
        }
        if (account.hasLicense()) {
            throw new LoginWaitException("Waiting for auth...", new LoginWaitException.LoginWaitTask(){

                @Override
                public void runTask() {
                    account.getAuthenticator().pass(AccountComboBox.this.listener);
                }
            });
        }
    }

    @Override
    public void onLoginFailed() {
    }

    @Override
    public void onLoginSuccess() {
    }

    public void refreshAccounts(AuthenticatorDatabase db, String select) {
        if (select == null && this.selectedAccount != null) {
            select = this.selectedAccount;
        }
        this.removeAllItems();
        Collection<Account> list = db.getAccounts();
        if (list.isEmpty()) {
            this.addItem(EMPTY);
        } else {
            for (Account account : list) {
                this.addItem(account);
                if (select == null || !select.equals(account.getUsername())) continue;
                this.setSelectedItem(account);
            }
        }
        this.addItem(MANAGE);
    }

    @Override
    public void updateLocale() {
        this.refreshAccounts(this.manager.getAuthDatabase(), null);
    }

    @Override
    public void onAccountsRefreshed(AuthenticatorDatabase db) {
        this.refreshAccounts(db, null);
    }

    @Override
    public void onProfilesRefreshed(ProfileManager pm) {
        this.refreshAccounts(pm.getAuthDatabase(), null);
    }

    @Override
    public void onProfileManagerChanged(ProfileManager pm) {
        this.refreshAccounts(pm.getAuthDatabase(), null);
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }
}

