/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.login;

import com.turikhay.tlauncher.ui.alert.Alert;
import com.turikhay.tlauncher.ui.block.BlockablePanel;
import com.turikhay.tlauncher.ui.loc.Localizable;
import com.turikhay.tlauncher.ui.loc.LocalizableCheckbox;
import com.turikhay.tlauncher.ui.login.LoginException;
import com.turikhay.tlauncher.ui.login.LoginForm;
import com.turikhay.tlauncher.ui.login.LoginListener;
import com.turikhay.tlauncher.ui.swing.CheckBoxListener;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import net.minecraft.launcher.updater.VersionSyncInfo;

public class CheckBoxPanel
extends BlockablePanel
implements LoginListener {
    private static final long serialVersionUID = 768489049585749260L;
    public final LocalizableCheckbox autologin;
    public final LocalizableCheckbox forceupdate;
    private boolean state;
    private final LoginForm loginForm;

    CheckBoxPanel(LoginForm lf) {
        BoxLayout lm = new BoxLayout(this, 3);
        this.setLayout(lm);
        this.setOpaque(false);
        this.setAlignmentX(0.5f);
        this.loginForm = lf;
        this.autologin = new LocalizableCheckbox("loginform.checkbox.autologin", lf.global.getBoolean("login.auto"));
        this.autologin.addItemListener(new CheckBoxListener(){

            @Override
            public void itemStateChanged(boolean newstate) {
                ((CheckBoxPanel)CheckBoxPanel.this).loginForm.autologin.setEnabled(newstate);
                if (newstate) {
                    Alert.showAsyncMessage("loginform.checkbox.autologin.tip", Localizable.get("loginform.checkbox.autologin.tip.arg"));
                }
            }
        });
        this.forceupdate = new LocalizableCheckbox("loginform.checkbox.forceupdate");
        this.forceupdate.addItemListener(new CheckBoxListener(){

            @Override
            public void itemStateChanged(boolean newstate) {
                CheckBoxPanel.this.state = newstate;
                ((CheckBoxPanel)CheckBoxPanel.this).loginForm.buttons.play.updateState();
            }
        });
        this.add((Component)this.autologin);
        this.add(Box.createHorizontalGlue());
        this.add((Component)this.forceupdate);
    }

    @Override
    public void onLogin() throws LoginException {
        VersionSyncInfo syncInfo = this.loginForm.versions.getVersion();
        if (syncInfo == null) {
            return;
        }
        boolean supporting = syncInfo.hasRemote();
        boolean installed = syncInfo.isInstalled();
        if (this.state) {
            if (!supporting) {
                Alert.showWarning("forceupdate.onlylibraries");
            } else if (installed && !Alert.showQuestion("forceupdate.question", true)) {
                throw new LoginException("User has cancelled force updating.");
            }
        }
    }

    @Override
    public void onLoginFailed() {
    }

    @Override
    public void onLoginSuccess() {
    }
}

