/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.settings;

import com.turikhay.tlauncher.ui.settings.SettingsFieldChangeListener;
import com.turikhay.tlauncher.ui.settings.SettingsFieldListener;
import com.turikhay.tlauncher.ui.settings.SettingsHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SettingsGroupHandler {
    private final SettingsHandler[] handlers;
    private final SettingsFieldListener listener;
    protected final List<SettingsFieldChangeListener> listeners;
    private final int checkedLimit;
    private int changedFlag;
    private int checkedFlag;

    SettingsGroupHandler(SettingsHandler ... handlers) {
        if (handlers == null) {
            throw new NullPointerException();
        }
        this.checkedLimit = handlers.length;
        this.listener = new SettingsFieldListener(){

            @Override
            protected void onChange(SettingsHandler handler, String oldValue, String newValue) {
                if (newValue == null) {
                    return;
                }
                if (!newValue.equals(oldValue)) {
                    SettingsGroupHandler settingsGroupHandler = SettingsGroupHandler.this;
                    settingsGroupHandler.changedFlag = settingsGroupHandler.changedFlag + 1;
                }
                SettingsGroupHandler settingsGroupHandler = SettingsGroupHandler.this;
                settingsGroupHandler.checkedFlag = settingsGroupHandler.checkedFlag + 1;
                if (SettingsGroupHandler.this.checkedFlag == SettingsGroupHandler.this.checkedLimit) {
                    if (SettingsGroupHandler.this.changedFlag > 0) {
                        for (SettingsFieldChangeListener listener : SettingsGroupHandler.this.listeners) {
                            listener.onChange(null, null);
                        }
                    }
                    SettingsGroupHandler.this.changedFlag = 0;
                    SettingsGroupHandler.this.checkedFlag = 0;
                }
            }
        };
        int i = 0;
        while (i < handlers.length) {
            SettingsHandler handler = handlers[i];
            if (handler == null) {
                throw new NullPointerException("Handler is NULL at " + i);
            }
            handler.addListener(this.listener);
            ++i;
        }
        this.handlers = new SettingsHandler[handlers.length];
        System.arraycopy(handlers, 0, this.handlers, 0, handlers.length);
        this.listeners = Collections.synchronizedList(new ArrayList());
    }

    public boolean addListener(SettingsFieldChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return this.listeners.add(listener);
    }

    public boolean removeListener(SettingsFieldChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return this.listeners.remove(listener);
    }
}

