/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.swing.extended;

import com.turikhay.tlauncher.ui.converter.StringConverter;
import com.turikhay.tlauncher.ui.swing.extended.DefaultConverterCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;

public class ExtendedComboBox<T>
extends JComboBox<T> {
    private static final long serialVersionUID = -4509947341182373649L;
    private StringConverter<T> converter;

    public ExtendedComboBox(ListCellRenderer<T> renderer) {
        this.setRenderer(renderer);
        this.setOpaque(false);
        ((JComponent)this.getEditor().getEditorComponent()).setOpaque(false);
    }

    public ExtendedComboBox(StringConverter<T> converter) {
        this(new DefaultConverterCellRenderer<T>(converter));
        this.converter = converter;
    }

    public ExtendedComboBox() {
        this((ListCellRenderer<T>)null);
    }

    public T getValueAt(int i) {
        Object value = this.getItemAt(i);
        return this.returnAs(value);
    }

    public T getSelectedValue() {
        Object selected = this.getSelectedItem();
        return this.returnAs(selected);
    }

    public void setSelectedValue(T value) {
        this.setSelectedItem(value);
    }

    public void setSelectedValue(String string) {
        T value = this.convert(string);
        if (value == null) {
            return;
        }
        this.setSelectedValue(value);
    }

    public StringConverter<T> getConverter() {
        return this.converter;
    }

    public void setConverter(StringConverter<T> converter) {
        this.converter = converter;
    }

    protected String convert(T obj) {
        T from = this.returnAs(obj);
        if (this.converter != null) {
            return this.converter.toValue(from);
        }
        return from == null ? null : from.toString();
    }

    protected T convert(String from) {
        if (this.converter != null) {
            return this.converter.fromString(from);
        }
        return null;
    }

    private T returnAs(Object obj) {
        try {
            return (T)obj;
        }
        catch (ClassCastException ce) {
            return null;
        }
    }
}

