/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.util;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.configuration.Configuration;
import com.turikhay.util.async.ExtendedThread;
import java.net.URI;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Random;

public class U {
    public static final int DEFAULT_READ_TIMEOUT = 15000;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    private static String PREFIX;
    private static Object lock;

    static {
        lock = new Object();
    }

    public static void setPrefix(String prefix) {
        PREFIX = prefix;
    }

    public static String getPrefix() {
        return PREFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void linelog(Object what) {
        Object object = lock;
        synchronized (object) {
            System.out.print(what);
        }
    }

    public static void log(Object ... what) {
        U.hlog(PREFIX, what);
    }

    public static void plog(Object ... what) {
        U.hlog(null, what);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void hlog(String prefix, Object[] append) {
        Object object = lock;
        synchronized (object) {
            System.out.println(U.toLog(prefix, append));
        }
    }

    public static String toLog(String prefix, Object ... append) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        if (prefix != null) {
            b.append(prefix);
            first = false;
        }
        if (append != null) {
            Object[] objectArray = append;
            int n = append.length;
            int n2 = 0;
            while (n2 < n) {
                Object e = objectArray[n2];
                if (e != null && e.getClass().isArray()) {
                    if (!first) {
                        b.append(" ");
                    }
                    if (e instanceof Object[]) {
                        b.append(U.toLog((Object[])e));
                    } else {
                        b.append(U.arrayToLog(e));
                    }
                } else if (e instanceof Throwable) {
                    if (!first) {
                        b.append("\n");
                    }
                    b.append(U.stackTrace((Throwable)e));
                    b.append("\n");
                } else {
                    if (e instanceof Iterator) {
                        Iterator i = (Iterator)e;
                        while (i.hasNext()) {
                            b.append(" ");
                            b.append(U.toLog(i.next()));
                        }
                    } else {
                        if (!first) {
                            b.append(" ");
                        }
                        b.append(e);
                    }
                    if (first) {
                        first = false;
                    }
                }
                ++n2;
            }
        } else {
            b.append("null");
        }
        return b.toString();
    }

    public static String toLog(Object ... append) {
        return U.toLog(null, append);
    }

    public static String arrayToLog(Object e) {
        if (!e.getClass().isArray()) {
            throw new IllegalArgumentException("Given object is not an array!");
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        if (e instanceof Object[]) {
            Object[] objectArray = (Object[])e;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object i = objectArray[n2];
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
                ++n2;
            }
        } else if (e instanceof int[]) {
            int[] nArray = (int[])e;
            int n = nArray.length;
            int n3 = 0;
            while (n3 < n) {
                int i = nArray[n3];
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
                ++n3;
            }
        } else if (e instanceof boolean[]) {
            boolean[] blArray = (boolean[])e;
            int n = blArray.length;
            int n4 = 0;
            while (n4 < n) {
                boolean i = blArray[n4];
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
                ++n4;
            }
        } else if (e instanceof long[]) {
            long[] lArray = (long[])e;
            int n = lArray.length;
            int n5 = 0;
            while (n5 < n) {
                long i = lArray[n5];
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
                ++n5;
            }
        } else if (e instanceof float[]) {
            float[] fArray = (float[])e;
            int n = fArray.length;
            int n6 = 0;
            while (n6 < n) {
                float i = fArray[n6];
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
                ++n6;
            }
        } else if (e instanceof double[]) {
            double[] dArray = (double[])e;
            int n = dArray.length;
            int n7 = 0;
            while (n7 < n) {
                double i = dArray[n7];
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
                ++n7;
            }
        } else if (e instanceof byte[]) {
            byte[] byArray = (byte[])e;
            int n = byArray.length;
            int n8 = 0;
            while (n8 < n) {
                byte i = byArray[n8];
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
                ++n8;
            }
        } else if (e instanceof short[]) {
            short[] sArray = (short[])e;
            int n = sArray.length;
            int n9 = 0;
            while (n9 < n) {
                short i = sArray[n9];
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
                ++n9;
            }
        } else if (e instanceof char[]) {
            char[] cArray = (char[])e;
            int n = cArray.length;
            int n10 = 0;
            while (n10 < n) {
                char i = cArray[n10];
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
                ++n10;
            }
        }
        if (b.length() == 0) {
            throw new UnknownError("Unknown array type given.");
        }
        return b.toString();
    }

    public static short shortRandom() {
        return (short)new Random(System.currentTimeMillis()).nextInt(Short.MAX_VALUE);
    }

    public static double doubleRandom() {
        return new Random(System.currentTimeMillis()).nextDouble();
    }

    public static int random(int s, int e) {
        return new Random(System.currentTimeMillis()).nextInt(e - s) + s;
    }

    public static boolean ok(int d) {
        return new Random(System.currentTimeMillis()).nextInt(d) == 0;
    }

    public static double getAverage(double[] d) {
        double a = 0.0;
        int k = 0;
        double[] dArray = d;
        int n = d.length;
        int n2 = 0;
        while (n2 < n) {
            double curd = dArray[n2];
            if (curd != 0.0) {
                a += curd;
                ++k;
            }
            ++n2;
        }
        if (k == 0) {
            return 0.0;
        }
        return a / (double)k;
    }

    public static double getAverage(double[] d, int max) {
        double a = 0.0;
        int k = 0;
        double[] dArray = d;
        int n = d.length;
        int n2 = 0;
        while (n2 < n) {
            double curd = dArray[n2];
            a += curd;
            if (++k == max) break;
            ++n2;
        }
        if (k == 0) {
            return 0.0;
        }
        return a / (double)k;
    }

    public static int getAverage(int[] d) {
        int a = 0;
        int k = 0;
        int[] nArray = d;
        int n = d.length;
        int n2 = 0;
        while (n2 < n) {
            int curd = nArray[n2];
            if (curd != 0) {
                a += curd;
                ++k;
            }
            ++n2;
        }
        if (k == 0) {
            return 0;
        }
        return Math.round(a / k);
    }

    public static int getAverage(int[] d, int max) {
        int a = 0;
        int k = 0;
        int[] nArray = d;
        int n = d.length;
        int n2 = 0;
        while (n2 < n) {
            int curd = nArray[n2];
            a += curd;
            if (++k == max) break;
            ++n2;
        }
        if (k == 0) {
            return 0;
        }
        return Math.round(a / k);
    }

    public static int getSum(int[] d) {
        int a = 0;
        int[] nArray = d;
        int n = d.length;
        int n2 = 0;
        while (n2 < n) {
            int curd = nArray[n2];
            a += curd;
            ++n2;
        }
        return a;
    }

    public static double getSum(double[] d) {
        double a = 0.0;
        double[] dArray = d;
        int n = d.length;
        int n2 = 0;
        while (n2 < n) {
            double curd = dArray[n2];
            a += curd;
            ++n2;
        }
        return a;
    }

    public static int getMaxMultiply(int i, int max) {
        if (i <= max) {
            return 1;
        }
        int x = max;
        while (x > 1) {
            if (i % x == 0) {
                return x;
            }
            --x;
        }
        return (int)Math.ceil(i / max);
    }

    public static String r(String string, int max) {
        if (string == null) {
            return null;
        }
        int len = string.length();
        if (len <= max) {
            return string;
        }
        String[] words = string.split(" ");
        String ret = "";
        int remaining = max + 1;
        int x = 0;
        while (x < words.length) {
            String curword = words[x];
            int curlen = curword.length();
            if (curlen < remaining) {
                ret = String.valueOf(ret) + " " + curword;
                remaining -= curlen + 1;
            } else {
                if (x != 0) break;
                ret = String.valueOf(ret) + " " + curword.substring(0, remaining - 1);
                break;
            }
            ++x;
        }
        if (ret.length() == 0) {
            return "";
        }
        return String.valueOf(ret.substring(1)) + "...";
    }

    public static String t(String string, int max) {
        if (string == null) {
            return null;
        }
        int len = string.length();
        if (len <= max) {
            return string;
        }
        return String.valueOf(string.substring(0, max)) + "...";
    }

    public static String w(String string, int normal, char newline, boolean rude) {
        char[] c = string.toCharArray();
        int len = c.length;
        int remaining = normal;
        String ret = "";
        int x = 0;
        while (x < len) {
            --remaining;
            char cur = c[x];
            if (c[x] == newline) {
                remaining = normal;
            }
            if (remaining < 1 && cur == ' ') {
                remaining = normal;
                ret = String.valueOf(ret) + newline;
            } else {
                ret = String.valueOf(ret) + cur;
                if (remaining <= 0 && rude) {
                    remaining = normal;
                    ret = String.valueOf(ret) + newline;
                }
            }
            ++x;
        }
        return ret;
    }

    public static String w(String string, int max) {
        return U.w(string, max, '\n', false);
    }

    public static String w(String string, int max, boolean rude) {
        return U.w(string, max, '\n', rude);
    }

    public static String setFractional(double d, int fractional) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(fractional);
        return nf.format(d).replace(",", ".");
    }

    public static String stackTrace(Throwable e) {
        Thread current = Thread.currentThread();
        String callerTrace = null;
        if (current instanceof ExtendedThread) {
            callerTrace = "\nThread called by: " + U.stackTrace0(((ExtendedThread)current).getCaller());
        }
        return String.valueOf(U.stackTrace0(e)) + (callerTrace == null ? "" : callerTrace);
    }

    private static String stackTrace0(Throwable e) {
        Throwable cause;
        if (e == null) {
            return null;
        }
        String t = e.toString();
        if (t == null) {
            t = "";
        }
        StackTraceElement[] elems = e.getStackTrace();
        int found_out = 0;
        int x = 0;
        while (x < elems.length) {
            String elem = elems[x].toString();
            t = String.valueOf(t) + "\nat " + elem;
            if (elem.startsWith("com.turikhay")) {
                ++found_out;
            }
            if (found_out >= 5 || x >= 15) {
                int remain = elems.length - x - 1;
                if (remain == 0) break;
                t = String.valueOf(t) + "\n... and " + remain + " more";
                break;
            }
            ++x;
        }
        if ((cause = e.getCause()) != null) {
            t = String.valueOf(t) + "\nCaused by: " + U.stackTrace0(cause);
        }
        return t;
    }

    public static long getUsingSpace() {
        return U.getTotalSpace() - U.getFreeSpace();
    }

    public static long getFreeSpace() {
        return Runtime.getRuntime().freeMemory() / 0x100000L;
    }

    public static long getTotalSpace() {
        return Runtime.getRuntime().totalMemory() / 0x100000L;
    }

    public static void gc() {
        U.log("Starting garbage collector: " + U.getUsingSpace() + " / " + U.getTotalSpace() + " MB");
        System.gc();
        U.log("Garbage collector completed: " + U.getUsingSpace() + " / " + U.getTotalSpace() + " MB");
    }

    public static void sleepFor(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static URL makeURL(String p) {
        try {
            return new URL(p);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static URI makeURI(URL url) {
        try {
            return url.toURI();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static URI makeURI(String p) {
        return U.makeURI(U.makeURL(p));
    }

    public static boolean interval(int min, int max, int num, boolean including) {
        return including ? num >= min && num <= max : num > max && num < max;
    }

    public static boolean interval(int min, int max, int num) {
        return U.interval(min, max, num, true);
    }

    public static long m() {
        return System.currentTimeMillis();
    }

    public static long n() {
        return System.nanoTime();
    }

    public static int getReadTimeout() {
        return U.getConnectionTimeout();
    }

    public static int getConnectionTimeout() {
        TLauncher t = TLauncher.getInstance();
        if (t == null) {
            return 15000;
        }
        Configuration.ConnectionQuality quality = t.getSettings().getConnectionQuality();
        if (quality == null) {
            return 15000;
        }
        return quality.getTimeout();
    }
}

