/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.util.async;

import com.turikhay.util.async.AsyncContainerLockedException;
import com.turikhay.util.async.AsyncObject;
import com.turikhay.util.async.AsyncObjectGotErrorException;
import com.turikhay.util.async.AsyncObjectNotReadyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsyncObjectContainer<T> {
    private List<AsyncObject<T>> objects = new ArrayList<AsyncObject<T>>();
    private Map<AsyncObject<T>, T> values = new HashMap<AsyncObject<T>, T>();
    private boolean executionLock;

    public AsyncObjectContainer() {
    }

    public AsyncObjectContainer(AsyncObject<T>[] asyncObjects) {
        this();
        AsyncObject<T>[] asyncObjectArray = asyncObjects;
        int n = asyncObjects.length;
        int n2 = 0;
        while (n2 < n) {
            AsyncObject<T> object = asyncObjectArray[n2];
            this.add(object);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<AsyncObject<T>, T> execute() {
        this.executionLock = true;
        this.values.clear();
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            int i = 0;
            int size = this.objects.size();
            for (AsyncObject<T> object : this.objects) {
                object.start();
            }
            while (i < size) {
                for (AsyncObject<T> object : this.objects) {
                    try {
                        if (this.values.containsKey(object)) continue;
                        this.values.put(object, object.getValue());
                        ++i;
                    }
                    catch (AsyncObjectNotReadyException asyncObjectNotReadyException) {
                    }
                    catch (AsyncObjectGotErrorException ignored0) {
                        this.values.put(object, null);
                        ++i;
                    }
                }
            }
        }
        this.executionLock = false;
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AsyncObject<T> object) {
        if (object == null) {
            throw new NullPointerException();
        }
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            if (this.executionLock) {
                throw new AsyncContainerLockedException();
            }
            this.objects.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AsyncObject<T> object) {
        if (object == null) {
            throw new NullPointerException();
        }
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            if (this.executionLock) {
                throw new AsyncContainerLockedException();
            }
            this.objects.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            if (this.executionLock) {
                throw new AsyncContainerLockedException();
            }
            this.objects.clear();
        }
    }
}

