/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.util.logger;

import com.turikhay.util.logger.LinkedStringStream;
import com.turikhay.util.logger.Logger;
import java.io.IOException;
import java.io.OutputStream;

public class MirroredLinkedStringStream
extends LinkedStringStream {
    private OutputStream mirror;

    public MirroredLinkedStringStream() {
    }

    public MirroredLinkedStringStream(Logger logger, OutputStream mirror) {
        super(logger);
        this.mirror = mirror;
    }

    public MirroredLinkedStringStream(Logger logger) {
        this(logger, null);
    }

    public MirroredLinkedStringStream(OutputStream mirror) {
        this(null, mirror);
    }

    public OutputStream getMirror() {
        return this.mirror;
    }

    public void setMirror(OutputStream stream) {
        this.mirror = stream;
    }

    @Override
    public void write(char b) {
        super.write(b);
        if (this.mirror != null) {
            try {
                this.mirror.write(b);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot log into the mirror!", e);
            }
        }
    }

    @Override
    public void flush() {
        super.flush();
        if (this.mirror != null) {
            try {
                this.mirror.flush();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot flush the mirror!", e);
            }
        }
    }
}

