/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.turikhay.util.Time;
import com.turikhay.util.U;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.PartialVersion;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Version;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;

public abstract class VersionList {
    protected final Gson gson;
    private final Map<String, Version> byName;
    private final List<Version> versions = new ArrayList<Version>();

    public VersionList() {
        this.byName = new HashMap<String, Version>();
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)CompleteVersion.class), new CompleteVersion.CompleteVersionSerializer());
        builder.enableComplexMapKeySerialization();
        builder.setPrettyPrinting();
        this.gson = builder.create();
    }

    public List<Version> getVersions() {
        return Collections.unmodifiableList(this.versions);
    }

    public Version getVersion(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be NULL or empty");
        }
        return this.byName.get(name);
    }

    public CompleteVersion getCompleteVersion(Version version) throws JsonSyntaxException, IOException {
        if (version instanceof CompleteVersion) {
            return (CompleteVersion)version;
        }
        if (version == null) {
            throw new NullPointerException("Version cannot be NULL!");
        }
        CompleteVersion complete = this.gson.fromJson(this.getUrl("versions/" + version.getID() + "/" + version.getID() + ".json"), CompleteVersion.class);
        complete.setID(version.getID());
        complete.setVersionList(this);
        Collections.replaceAll(this.versions, version, complete);
        return complete;
    }

    public CompleteVersion getCompleteVersion(String name) throws JsonSyntaxException, IOException {
        Version version = this.getVersion(name);
        if (version == null) {
            return null;
        }
        return this.getCompleteVersion(version);
    }

    public RawVersionList getRawList() throws IOException {
        Object lock = new Object();
        Time.start(lock);
        RawVersionList list = this.gson.fromJson(this.getUrl("versions/versions.json"), RawVersionList.class);
        for (PartialVersion version : list.versions) {
            version.setVersionList(this);
        }
        this.log("Got in", Time.stop(lock), "ms");
        return list;
    }

    public void refreshVersions(RawVersionList versionList) {
        this.clearCache();
        for (Version version : versionList.getVersions()) {
            this.versions.add(version);
            this.byName.put(version.getID(), version);
        }
    }

    public void refreshVersions() throws IOException {
        this.refreshVersions(this.getRawList());
    }

    public CompleteVersion addVersion(CompleteVersion version) {
        if (version.getID() == null) {
            throw new IllegalArgumentException("Cannot add blank version");
        }
        if (this.getVersion(version.getID()) != null) {
            this.log("Version '" + version.getID() + "' is already tracked");
            return version;
        }
        this.versions.add(version);
        this.byName.put(version.getID(), version);
        return version;
    }

    public void removeVersion(Version version) {
        if (version == null) {
            throw new NullPointerException("Version cannot be NULL!");
        }
        this.versions.remove(version);
        this.byName.remove(version);
    }

    public void removeVersion(String name) {
        Version version = this.getVersion(name);
        if (version == null) {
            return;
        }
        this.removeVersion(version);
    }

    public String serializeVersion(CompleteVersion version) {
        if (version == null) {
            throw new NullPointerException("CompleteVersion cannot be NULL!");
        }
        return this.gson.toJson(version);
    }

    public abstract boolean hasAllFiles(CompleteVersion var1, OperatingSystem var2);

    protected abstract String getUrl(String var1) throws IOException;

    protected void clearCache() {
        this.byName.clear();
        this.versions.clear();
    }

    protected void log(Object ... obj) {
        U.log("[" + this.getClass().getSimpleName() + "]", obj);
    }

    public static class RawVersionList {
        private List<PartialVersion> versions = new ArrayList<PartialVersion>();
        private Map<ReleaseType, String> latest = new EnumMap<ReleaseType, String>(ReleaseType.class);

        public List<PartialVersion> getVersions() {
            return this.versions;
        }

        public Map<ReleaseType, String> getLatestVersions() {
            return this.latest;
        }
    }
}

