/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import net.minecraft.launcher.versions.Version;

public class VersionSyncInfo {
    private final Version localVersion;
    private final Version remoteVersion;

    public VersionSyncInfo(Version localVersion, Version remoteVersion) {
        if (localVersion == null && remoteVersion == null) {
            throw new NullPointerException("Cannot create sync info from NULLs!");
        }
        this.localVersion = localVersion;
        this.remoteVersion = remoteVersion;
        if (this.getID() == null) {
            throw new NullPointerException("Cannot create sync info from versions that have NULL IDs");
        }
    }

    private VersionSyncInfo() {
        this.localVersion = null;
        this.remoteVersion = null;
    }

    public Version getLocal() {
        return this.localVersion;
    }

    public Version getRemote() {
        return this.remoteVersion;
    }

    public String getID() {
        if (this.localVersion != null) {
            return this.localVersion.getID();
        }
        if (this.remoteVersion != null) {
            return this.remoteVersion.getID();
        }
        return null;
    }

    public Version getLatestVersion() {
        if (this.remoteVersion != null) {
            return this.remoteVersion;
        }
        return this.localVersion;
    }

    public boolean isInstalled() {
        return this.localVersion != null;
    }

    public boolean hasRemote() {
        return this.remoteVersion != null;
    }

    public boolean isUpToDate() {
        if (this.localVersion == null) {
            return false;
        }
        if (this.remoteVersion == null) {
            return true;
        }
        return this.localVersion.getReleaseTime().compareTo(this.remoteVersion.getReleaseTime()) >= 0;
    }

    public String toString() {
        return "VersionSyncInfo{id='" + this.getID() + "',\nlocal=" + this.localVersion + ",\nremote=" + this.remoteVersion + ", isInstalled=" + this.isInstalled() + ", hasRemote=" + this.hasRemote() + ", isUpToDate=" + this.isUpToDate() + "}";
    }

    public static VersionSyncInfo createEmpty() {
        return new VersionSyncInfo();
    }
}

