/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions.json;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;

public class LowerCaseEnumTypeAdapterFactory
implements TypeAdapterFactory {
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class<T> rawType = type.getRawType();
        if (!rawType.isEnum()) {
            return null;
        }
        final HashMap<String, T> lowercaseToConstant = new HashMap<String, T>();
        T[] TArray = rawType.getEnumConstants();
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T constant = TArray[n2];
            lowercaseToConstant.put(this.toLowercase(constant), constant);
            ++n2;
        }
        return new TypeAdapter<T>(){

            @Override
            public void write(JsonWriter out, Object value) throws IOException {
                if (value == null) {
                    out.nullValue();
                } else {
                    out.value(LowerCaseEnumTypeAdapterFactory.this.toLowercase(value));
                }
            }

            @Override
            public T read(JsonReader reader) throws IOException {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return null;
                }
                return lowercaseToConstant.get(reader.nextString());
            }
        };
    }

    private String toLowercase(Object o) {
        return o.toString().toLowerCase(Locale.US);
    }
}

