/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.component.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.turikhay.tlauncher.component.RefreshableComponent;
import com.turikhay.tlauncher.component.managers.ProfileManagerListener;
import com.turikhay.tlauncher.minecraft.auth.AccountListener;
import com.turikhay.tlauncher.minecraft.auth.AuthenticatorDatabase;
import com.turikhay.tlauncher.minecraft.profiles.Profile;
import com.turikhay.util.FileUtil;
import com.turikhay.util.MinecraftUtil;
import com.turikhay.util.U;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.FileTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;

public class ProfileManager
extends RefreshableComponent {
    public static final String DEFAULT_PROFILE_NAME = "TLauncher";
    public static final String DEFAULT_PROFILE_FILENAME = "launcher_profiles.json";
    private final List<ProfileManagerListener> listeners;
    private final AccountListener accountListener;
    private final JsonParser parser = new JsonParser();
    private final Gson gson;
    private final Map<String, Profile> profiles;
    private String selectedProfile;
    private File file;
    private UUID clientToken;
    private AuthenticatorDatabase authDatabase;

    public ProfileManager(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.profiles = new HashMap<String, Profile>();
        this.clientToken = UUID.randomUUID();
        this.accountListener = new AccountListener(){

            @Override
            public void onAccountsRefreshed(AuthenticatorDatabase db) {
                for (AccountListener listener : ProfileManager.this.listeners) {
                    listener.onAccountsRefreshed(db);
                }
            }
        };
        this.authDatabase = new AuthenticatorDatabase();
        this.authDatabase.setListener(this.accountListener);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)File.class), new FileTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)AuthenticatorDatabase.class), new AuthenticatorDatabase.Serializer());
        builder.setPrettyPrinting();
        this.gson = builder.create();
    }

    public ProfileManager() {
        this(ProfileManager.getDefaultFile());
    }

    public void recreate() {
        this.setFile(ProfileManager.getDefaultFile());
    }

    @Override
    public boolean refresh() {
        this.loadProfiles();
        for (ProfileManagerListener listener : this.listeners) {
            listener.onProfilesRefreshed(this);
        }
        return true;
    }

    private void loadProfiles() {
        RawProfileList raw;
        this.selectedProfile = null;
        this.profiles.clear();
        if (!this.file.isFile()) {
            return;
        }
        try {
            raw = this.gson.fromJson((JsonElement)this.parser.parse(FileUtil.readFile(this.file)).getAsJsonObject(), RawProfileList.class);
        }
        catch (Exception e) {
            U.log("Cannot parse profile list! Loading an empty one.", e);
            raw = new RawProfileList();
        }
        this.clientToken = raw.clientToken;
        this.selectedProfile = raw.selectedProfile;
        this.authDatabase = raw.authenticationDatabase;
        this.authDatabase.setListener(this.accountListener);
        this.profiles.putAll(raw.profiles);
    }

    public void saveProfiles() throws IOException {
        RawProfileList raw = new RawProfileList();
        raw.clientToken = this.clientToken;
        raw.selectedProfile = this.selectedProfile;
        raw.profiles = this.profiles;
        raw.authenticationDatabase = this.authDatabase;
        FileUtil.writeFile(this.file, this.gson.toJson(raw));
    }

    public AuthenticatorDatabase getAuthDatabase() {
        return this.authDatabase;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        for (ProfileManagerListener listener : this.listeners) {
            listener.onProfileManagerChanged(this);
        }
    }

    public UUID getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String uuid) {
        this.clientToken = UUID.fromString(uuid);
    }

    public void addListener(ProfileManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private static File getDefaultFile() {
        return new File(MinecraftUtil.getWorkingDirectory(), DEFAULT_PROFILE_FILENAME);
    }

    static class RawProfileList {
        Map<String, Profile> profiles = new HashMap<String, Profile>();
        String selectedProfile;
        UUID clientToken = UUID.randomUUID();
        AuthenticatorDatabase authenticationDatabase = new AuthenticatorDatabase();

        RawProfileList() {
        }
    }
}

