/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.component.managers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.turikhay.tlauncher.component.InterruptibleComponent;
import com.turikhay.tlauncher.component.managers.ServerList;
import com.turikhay.tlauncher.component.managers.ServerListManagerListener;
import com.turikhay.tlauncher.minecraft.repository.ServerListRepository;
import com.turikhay.util.Time;
import com.turikhay.util.U;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ServerListManager
extends InterruptibleComponent {
    private final Gson gson;
    private final ServerListRepository repository;
    private ServerList serverList;
    private final List<ServerListManagerListener> listeners;

    public ServerListManager(ServerListRepository repository) {
        if (repository == null) {
            throw new NullPointerException("Repository cannot be NULL!");
        }
        this.repository = repository;
        this.gson = new Gson();
        this.listeners = Collections.synchronizedList(new ArrayList());
    }

    public ServerListManager() {
        this(ServerListRepository.DEFAULT_REPOSITORY);
    }

    public ServerList getList() {
        return this.serverList;
    }

    @Override
    protected boolean refresh(int refreshID) {
        this.refreshList[refreshID] = true;
        this.log("Refreshing servers...");
        for (ServerListManagerListener listener : this.listeners) {
            listener.onServersRefreshing(this);
        }
        Object lock = new Object();
        Time.start(lock);
        ServerList result = null;
        Throwable e = null;
        try {
            result = this.loadFromList();
        }
        catch (Throwable e0) {
            e = e0;
        }
        if (this.isCancelled(refreshID)) {
            this.log("Server list refreshing has been cancelled (" + Time.stop(lock) + " ms)");
            return false;
        }
        if (e != null) {
            for (ServerListManagerListener listener : this.listeners) {
                listener.onServersRefreshingFailed(this);
            }
            this.log("Cannot refresh servers (" + Time.stop(lock) + " ms)", e);
            return true;
        }
        if (result != null) {
            this.serverList = result;
        }
        this.log("Servers has been refreshed (" + Time.stop(lock) + " ms)");
        this.log(this.serverList);
        this.refreshList[refreshID] = false;
        for (ServerListManagerListener listener : this.listeners) {
            listener.onServersRefreshed(this);
        }
        return true;
    }

    public boolean reconstructList(String version, File listFile) throws IOException {
        this.log("Reconstructing server list (servers.dat)...");
        if (version == null) {
            throw new NullPointerException("Version cannot be NULL!");
        }
        if (listFile == null) {
            throw new NullPointerException("File cannot be NULL!");
        }
        if (this.serverList == null) {
            this.log("Promoted server list is NULL. Server list won't be reconstructed.");
            return false;
        }
        if (this.serverList.isEmpty()) {
            this.log("Promoted server list is empty. Server list won't be reconstructed.");
            return false;
        }
        ServerList list = new ServerList();
        for (ServerList.Server prefServer : this.serverList.getList()) {
            if (!version.matches(prefServer.getVersion())) continue;
            list.add(prefServer);
        }
        ServerList userList = ServerList.loadFromFile(listFile);
        for (ServerList.Server prefServer : this.serverList.getList()) {
            if (!userList.contains(prefServer)) continue;
            userList.remove(prefServer);
        }
        ServerList resultList = ServerList.sortLists(list, userList);
        resultList.save(listFile);
        return true;
    }

    private ServerList loadFromList() throws JsonSyntaxException, IOException {
        Object lock = new Object();
        Time.start(lock);
        ServerList list = this.gson.fromJson(this.repository.getUrl(), ServerList.class);
        this.log("Got in", Time.stop(lock), "ms");
        return list;
    }

    protected void log(Object ... w) {
        U.log("[" + this.getClass().getSimpleName() + "]", w);
    }
}

