/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.component.managers;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.component.InterruptibleComponent;
import com.turikhay.tlauncher.component.managers.ComponentManager;
import com.turikhay.tlauncher.component.managers.VersionManagerListener;
import com.turikhay.tlauncher.downloader.Downloadable;
import com.turikhay.tlauncher.downloader.DownloadableContainer;
import com.turikhay.tlauncher.minecraft.repository.VersionRepository;
import com.turikhay.util.Time;
import com.turikhay.util.U;
import com.turikhay.util.async.AsyncObject;
import com.turikhay.util.async.AsyncObjectContainer;
import com.turikhay.util.async.AsyncThread;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.RemoteVersionList;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.updater.VersionList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Version;

public class VersionManager
extends InterruptibleComponent {
    private final LocalVersionList localList;
    private final RemoteVersionList[] remoteLists;
    private final List<VersionManagerListener> listeners;
    private final Object versionFlushLock;

    public VersionManager(LocalVersionList local, RemoteVersionList ... lists) {
        if (local == null) {
            throw new NullPointerException("LocalVersionList is NULL!");
        }
        if (lists == null) {
            throw new NullPointerException("RemoteVersionList array is NULL!");
        }
        this.localList = local;
        this.remoteLists = lists;
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.versionFlushLock = new Object();
    }

    public VersionManager(ComponentManager manager) {
        this(manager.getVersionLists().getLocal(), manager.getVersionLists().getRemoteLists());
    }

    public void addListener(VersionManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    public LocalVersionList getLocalList() {
        return this.localList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refresh(int refreshID, boolean local) {
        this.refreshList[refreshID] = true;
        this.log("Refreshing versions...");
        for (VersionManagerListener listener : this.listeners) {
            listener.onVersionsRefreshing(this);
        }
        Object lock = new Object();
        Time.start(lock);
        Map<AsyncObject<VersionList.RawVersionList>, VersionList.RawVersionList> result = null;
        Throwable e = null;
        try {
            result = this.refreshVersions(local);
        }
        catch (Throwable throwable) {
            e = throwable;
        }
        if (this.isCancelled(refreshID)) {
            this.log("Version refresh has been cancelled (" + Time.stop(lock) + " ms)");
            return false;
        }
        if (e != null) {
            for (VersionManagerListener versionManagerListener : this.listeners) {
                versionManagerListener.onVersionsRefreshingFailed(this);
            }
            this.log("Cannot refresh versions (" + Time.stop(lock) + " ms)", e);
            return true;
        }
        if (result != null) {
            Object object = this.versionFlushLock;
            synchronized (object) {
                for (AsyncObject<VersionList.RawVersionList> object2 : result.keySet()) {
                    VersionList.RawVersionList rawList = result.get(object2);
                    if (rawList == null) continue;
                    AsyncRawVersionListObject listObject = (AsyncRawVersionListObject)object2;
                    listObject.getVersionList().refreshVersions(rawList);
                }
            }
        }
        this.log("Versions has been refreshed (" + Time.stop(lock) + " ms)");
        this.refreshList[refreshID] = false;
        for (VersionManagerListener versionManagerListener : this.listeners) {
            versionManagerListener.onVersionsRefreshed(this);
        }
        return true;
    }

    @Override
    protected boolean refresh(int queueID) {
        return this.refresh(queueID, false);
    }

    public void startRefresh(boolean local) {
        this.refresh(this.nextID(), local);
    }

    @Override
    public synchronized void stopRefresh() {
        super.stopRefresh();
        this.startRefresh(true);
    }

    public void asyncRefresh(final boolean local) {
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                VersionManager.this.startRefresh(local);
            }
        });
    }

    public void asyncRefresh() {
        this.asyncRefresh(false);
    }

    private Map<AsyncObject<VersionList.RawVersionList>, VersionList.RawVersionList> refreshVersions(boolean local) throws IOException {
        this.localList.refreshVersions();
        if (local) {
            return null;
        }
        AsyncObjectContainer<VersionList.RawVersionList> container = new AsyncObjectContainer<VersionList.RawVersionList>();
        RemoteVersionList[] remoteVersionListArray = this.remoteLists;
        int n = this.remoteLists.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteVersionList remoteList = remoteVersionListArray[n2];
            container.add(new AsyncRawVersionListObject(remoteList));
            ++n2;
        }
        return container.execute();
    }

    public void updateVersionList() {
        for (VersionManagerListener listener : this.listeners) {
            listener.onVersionsRefreshed(this);
        }
    }

    public VersionSyncInfo getVersionSyncInfo(Version version) {
        return this.getVersionSyncInfo(version.getID());
    }

    public VersionSyncInfo getVersionSyncInfo(String name) {
        if (name == null) {
            throw new NullPointerException("Cannot get sync info of NULL!");
        }
        Version localVersion = this.localList.getVersion(name);
        Version remoteVersion = null;
        RemoteVersionList[] remoteVersionListArray = this.remoteLists;
        int n = this.remoteLists.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteVersionList list = remoteVersionListArray[n2];
            Version currentVersion = list.getVersion(name);
            if (currentVersion != null) {
                remoteVersion = currentVersion;
                break;
            }
            ++n2;
        }
        return new VersionSyncInfo(localVersion, remoteVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VersionSyncInfo> getVersions(VersionFilter filter) {
        Object object = this.versionFlushLock;
        synchronized (object) {
            return this.getVersions0(filter);
        }
    }

    public List<VersionSyncInfo> getVersions() {
        return this.getVersions(TLauncher.getInstance() == null ? null : TLauncher.getInstance().getSettings().getVersionFilter());
    }

    private List<VersionSyncInfo> getVersions0(VersionFilter filter) {
        if (filter == null) {
            filter = new VersionFilter();
        }
        ArrayList<VersionSyncInfo> result = new ArrayList<VersionSyncInfo>();
        HashMap<String, VersionSyncInfo> lookup = new HashMap<String, VersionSyncInfo>();
        for (Version version : this.localList.getVersions()) {
            if (!filter.satisfies(version)) continue;
            VersionSyncInfo syncInfo = this.getVersionSyncInfo(version);
            lookup.put(version.getID(), syncInfo);
            result.add(syncInfo);
        }
        RemoteVersionList[] remoteVersionListArray = this.remoteLists;
        int n = this.remoteLists.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteVersionList remoteList = remoteVersionListArray[n2];
            for (Version version : remoteList.getVersions()) {
                if (lookup.containsKey(version.getID()) || !filter.satisfies(version)) continue;
                VersionSyncInfo syncInfo = this.getVersionSyncInfo(version);
                lookup.put(version.getID(), syncInfo);
                result.add(syncInfo);
            }
            ++n2;
        }
        Collections.sort(result, new Comparator<VersionSyncInfo>(){

            @Override
            public int compare(VersionSyncInfo a, VersionSyncInfo b) {
                Version aVer = a.getLatestVersion();
                Version bVer = b.getLatestVersion();
                if (aVer.getReleaseTime() != null && bVer.getReleaseTime() != null) {
                    return bVer.getReleaseTime().compareTo(aVer.getReleaseTime());
                }
                return bVer.getUpdatedTime().compareTo(aVer.getUpdatedTime());
            }
        });
        return result;
    }

    public List<VersionSyncInfo> getInstalledVersions(VersionFilter filter) {
        if (filter == null) {
            filter = new VersionFilter();
        }
        ArrayList<VersionSyncInfo> result = new ArrayList<VersionSyncInfo>();
        for (Version version : this.localList.getVersions()) {
            result.add(this.getVersionSyncInfo(version));
        }
        return result;
    }

    public List<VersionSyncInfo> getInstalledVersions() {
        return this.getInstalledVersions(TLauncher.getInstance() == null ? null : TLauncher.getInstance().getSettings().getVersionFilter());
    }

    public CompleteVersion getCompleteVersion(VersionSyncInfo syncInfo, boolean latest) throws IOException {
        Version version = latest ? syncInfo.getLatestVersion() : (syncInfo.isInstalled() ? syncInfo.getLocal() : syncInfo.getRemote());
        U.log("Got comlete from: ", latest, syncInfo.isInstalled());
        return version.getVersionList().getCompleteVersion(version);
    }

    public CompleteVersion getLatestCompleteVersion(VersionSyncInfo syncInfo) throws IOException {
        return this.getCompleteVersion(syncInfo, true);
    }

    public void downloadVersion(DownloadableContainer job, VersionSyncInfo syncInfo, boolean force) throws IOException {
        String downloadPath;
        String jarFile;
        this.log("Downaloding version:", syncInfo);
        CompleteVersion version = this.getCompleteVersion(syncInfo, force);
        this.log("Complete:", version);
        File baseDirectory = this.localList.getBaseDirectory();
        job.addAll(version.getRequiredDownloadables(baseDirectory, force));
        if (!syncInfo.hasRemote()) {
            return;
        }
        String id = version.getID();
        String o_id = version.getOriginal();
        String saveFile = jarFile = "versions/";
        if (o_id != null) {
            downloadPath = VersionRepository.OFFICIAL.getSelectedRepo();
            jarFile = String.valueOf(jarFile) + o_id + "/" + o_id + ".jar";
            saveFile = String.valueOf(saveFile) + id + "/" + id + ".jar";
        } else {
            downloadPath = syncInfo.getLatestVersion().getSource().getSelectedRepo();
            saveFile = jarFile = String.valueOf(jarFile) + id + "/" + id + ".jar";
        }
        Downloadable d = new Downloadable(String.valueOf(downloadPath) + jarFile, new File(baseDirectory, saveFile), force);
        d.setAdditionalDestinations(new File[]{new File(d.getDestination() + ".bak")});
        job.add(d);
    }

    protected void log(Object ... w) {
        U.log("[" + this.getClass().getSimpleName() + "]", w);
    }

    class AsyncRawVersionListObject
    extends AsyncObject<VersionList.RawVersionList> {
        private final RemoteVersionList remoteList;

        AsyncRawVersionListObject(RemoteVersionList remoteList) {
            this.remoteList = remoteList;
        }

        protected RemoteVersionList getVersionList() {
            return this.remoteList;
        }

        @Override
        protected VersionList.RawVersionList execute() {
            try {
                return this.remoteList.getRawList();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

