/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.configuration;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.configuration.ArgumentParser;
import com.turikhay.tlauncher.configuration.ConfigurationDefaults;
import com.turikhay.tlauncher.configuration.PlainParser;
import com.turikhay.tlauncher.configuration.SimpleConfiguration;
import com.turikhay.tlauncher.exceptions.ParseException;
import com.turikhay.util.FileUtil;
import com.turikhay.util.IntegerArray;
import com.turikhay.util.MinecraftUtil;
import com.turikhay.util.U;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import joptsimple.OptionSet;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.versions.ReleaseType;

public class Configuration
extends SimpleConfiguration {
    private ConfigurationDefaults defaults;
    private Map<String, Object> constants;
    private List<Locale> defaultLocales;
    private List<Locale> supportedLocales;
    private boolean firstRun;

    private Configuration(URL url, OptionSet set) throws IOException {
        super(url);
        this.init(set);
    }

    private Configuration(File file, OptionSet set) {
        super(file);
        this.init(set);
    }

    public static Configuration createConfiguration(OptionSet set) throws IOException {
        File neighbor;
        Object path = set != null ? set.valueOf("settings") : null;
        String defaultName = TLauncher.getSettingsFile();
        File file = path == null ? ((neighbor = FileUtil.getNeighborFile(defaultName)).isFile() ? neighbor : MinecraftUtil.getSystemRelatedFile(defaultName)) : new File(path.toString());
        U.log("Loading configuration from file:", file);
        boolean firstRun = !file.exists();
        Configuration config = new Configuration(file, set);
        config.firstRun = firstRun;
        return config;
    }

    public static Configuration createConfiguration() throws IOException {
        return Configuration.createConfiguration(null);
    }

    private void init(OptionSet set) {
        this.comments = " TLauncher configuration file\n Created in " + TLauncher.getBrand() + " " + TLauncher.getVersion();
        this.defaults = new ConfigurationDefaults();
        this.constants = ArgumentParser.parse(set);
        this.set(this.constants, false);
        this.log("Constant values:", this.constants);
        int version = ConfigurationDefaults.getVersion();
        if (this.getDouble("settings.version") != (double)version) {
            this.clear();
        }
        this.set("settings.version", version, false);
        for (Map.Entry<String, Object> curen : this.defaults.getMap().entrySet()) {
            String key = curen.getKey();
            if (this.constants.containsKey(key)) {
                this.log("Key \"" + key + "\" is unsaveable!");
                continue;
            }
            String value = this.get(key);
            Object defvalue = curen.getValue();
            if (defvalue == null) continue;
            try {
                PlainParser.parse(value, defvalue);
            }
            catch (ParseException e) {
                this.log("Key \"" + key + "\" is invalid!", e);
                this.set(key, defvalue, false);
            }
        }
        this.defaultLocales = this.getDefaultLocales();
        this.supportedLocales = this.getSupportedLocales();
        Locale selected = Configuration.getLocaleOf(this.get("locale"));
        if (selected == null) {
            this.log("Selected locale is not supported, rolling back to default one");
            selected = Locale.getDefault();
        }
        if (!this.supportedLocales.contains(selected)) {
            this.log("Default locale is not supported, rolling back to global default one");
            selected = Locale.US;
        }
        this.set("locale", selected, false);
        if (this.isSaveable()) {
            try {
                this.save();
            }
            catch (IOException e) {
                this.log("Cannot save value!", e);
            }
        }
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    public boolean isSaveable(String key) {
        return !this.constants.containsKey(key);
    }

    public Locale getLocale() {
        return Configuration.getLocaleOf(this.get("locale"));
    }

    public Locale[] getLocales() {
        Locale[] locales = new Locale[this.supportedLocales.size()];
        return this.supportedLocales.toArray(locales);
    }

    public ActionOnLaunch getActionOnLaunch() {
        return ActionOnLaunch.get(this.get("minecraft.onlaunch"));
    }

    public ConsoleType getConsoleType() {
        return ConsoleType.get(this.get("gui.console"));
    }

    public ConnectionQuality getConnectionQuality() {
        return ConnectionQuality.get(this.get("connection"));
    }

    public int[] getWindowSize() {
        String plainValue = this.get("minecraft.size");
        int[] value = new int[2];
        if (plainValue == null) {
            return new int[2];
        }
        try {
            IntegerArray arr = IntegerArray.parseIntegerArray(plainValue);
            value[0] = arr.get(0);
            value[1] = arr.get(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public int[] getDefaultWindowSize() {
        String plainValue = this.getDefault("minecraft.size");
        return IntegerArray.parseIntegerArray(plainValue).toArray();
    }

    public VersionFilter getVersionFilter() {
        VersionFilter filter = new VersionFilter();
        ReleaseType[] releaseTypeArray = ReleaseType.getDefinable();
        int n = releaseTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean include;
            ReleaseType type = releaseTypeArray[n2];
            if (!type.equals((Object)ReleaseType.UNKNOWN) && !(include = this.getBoolean("minecraft.versions." + (Object)((Object)type)))) {
                filter.excludeType(type);
            }
            ++n2;
        }
        return filter;
    }

    @Override
    public String getDefault(String key) {
        return Configuration.getStringOf(this.defaults.get(key));
    }

    @Override
    public int getDefaultInteger(String key) {
        return Configuration.getIntegerOf(this.defaults.get(key), 0);
    }

    @Override
    public double getDefaultDouble(String key) {
        return Configuration.getDoubleOf(this.defaults.get(key), 0.0);
    }

    @Override
    public float getDefaultFloat(String key) {
        return Configuration.getFloatOf(this.defaults.get(key), 0.0f);
    }

    @Override
    public long getDefaultLong(String key) {
        return Configuration.getLongOf(this.defaults.get(key), 0L);
    }

    @Override
    public boolean getDefaultBoolean(String key) {
        return Configuration.getBooleanOf(this.defaults.get(key), false);
    }

    @Override
    public void set(String key, Object value, boolean flush) {
        if (this.constants.containsKey(key)) {
            return;
        }
        super.set(key, value, flush);
    }

    @Override
    public void save() throws IOException {
        if (!this.isSaveable()) {
            throw new UnsupportedOperationException();
        }
        Properties temp = Configuration.copyProperties(this.properties);
        for (String key : this.constants.keySet()) {
            temp.remove(key);
        }
        File file = (File)this.input;
        temp.store(new FileOutputStream(file), this.comments);
    }

    public File getFile() {
        if (!this.isSaveable()) {
            return null;
        }
        return (File)this.input;
    }

    private List<Locale> getSupportedLocales() {
        this.log("Searching for supported locales...");
        Pattern lang_pattern = Pattern.compile("lang/([\\w]+)\\.ini");
        File file = FileUtil.getRunningJar();
        ArrayList<Locale> locales = new ArrayList<Locale>();
        try {
            ZipEntry e;
            URL jar = file.toURI().toURL();
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((e = zip.getNextEntry()) != null) {
                String name = e.getName();
                Matcher mt = lang_pattern.matcher(name);
                if (!mt.matches()) continue;
                this.log("Found locale:", mt.group(1));
                locales.add(Configuration.getLocaleOf(mt.group(1)));
            }
        }
        catch (Exception e) {
            this.log("Cannot get locales!", e);
            return this.defaultLocales;
        }
        if (locales.isEmpty()) {
            return this.defaultLocales;
        }
        return locales;
    }

    private List<Locale> getDefaultLocales() {
        ArrayList<Locale> l = new ArrayList<Locale>();
        l.add(Configuration.getLocaleOf("en_US"));
        l.add(Configuration.getLocaleOf("ru_RU"));
        l.add(Configuration.getLocaleOf("uk_UA"));
        return l;
    }

    public static Locale getLocaleOf(String locale) {
        if (locale == null) {
            return null;
        }
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale cur = localeArray[n2];
            if (cur.toString().equals(locale)) {
                return cur;
            }
            ++n2;
        }
        return null;
    }

    public static enum ActionOnLaunch {
        HIDE,
        EXIT;


        public static boolean parse(String val) {
            if (val == null) {
                return false;
            }
            ActionOnLaunch[] actionOnLaunchArray = ActionOnLaunch.values();
            int n = actionOnLaunchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionOnLaunch cur = actionOnLaunchArray[n2];
                if (cur.toString().equalsIgnoreCase(val)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static ActionOnLaunch get(String val) {
            ActionOnLaunch[] actionOnLaunchArray = ActionOnLaunch.values();
            int n = actionOnLaunchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionOnLaunch cur = actionOnLaunchArray[n2];
                if (cur.toString().equalsIgnoreCase(val)) {
                    return cur;
                }
                ++n2;
            }
            return null;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public static ActionOnLaunch getDefault() {
            return HIDE;
        }
    }

    public static enum ConnectionQuality {
        GOOD(2, 5, 10, 15000),
        NORMAL(5, 10, 5, 45000),
        BAD(10, 20, 1, 120000);

        private final int minTries;
        private final int maxTries;
        private final int maxThreads;
        private final int timeout;
        private final int[] configuration;

        private ConnectionQuality(int minTries, int maxTries, int maxThreads, int timeout) {
            this.minTries = minTries;
            this.maxTries = maxTries;
            this.maxThreads = maxThreads;
            this.timeout = timeout;
            this.configuration = new int[]{minTries, maxTries, maxThreads};
        }

        public static boolean parse(String val) {
            if (val == null) {
                return false;
            }
            ConnectionQuality[] connectionQualityArray = ConnectionQuality.values();
            int n = connectionQualityArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionQuality cur = connectionQualityArray[n2];
                if (cur.toString().equalsIgnoreCase(val)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static ConnectionQuality get(String val) {
            ConnectionQuality[] connectionQualityArray = ConnectionQuality.values();
            int n = connectionQualityArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionQuality cur = connectionQualityArray[n2];
                if (cur.toString().equalsIgnoreCase(val)) {
                    return cur;
                }
                ++n2;
            }
            return null;
        }

        public int[] getConfiguration() {
            return this.configuration;
        }

        public int getMinTries() {
            return this.minTries;
        }

        public int getMaxTries() {
            return this.maxTries;
        }

        public int getMaxThreads() {
            return this.maxThreads;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public static ConnectionQuality getDefault() {
            return GOOD;
        }
    }

    public static enum ConsoleType {
        GLOBAL,
        MINECRAFT,
        NONE;


        public static boolean parse(String val) {
            if (val == null) {
                return false;
            }
            ConsoleType[] consoleTypeArray = ConsoleType.values();
            int n = consoleTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConsoleType cur = consoleTypeArray[n2];
                if (cur.toString().equalsIgnoreCase(val)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static ConsoleType get(String val) {
            ConsoleType[] consoleTypeArray = ConsoleType.values();
            int n = consoleTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConsoleType cur = consoleTypeArray[n2];
                if (cur.toString().equalsIgnoreCase(val)) {
                    return cur;
                }
                ++n2;
            }
            return null;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public static ConsoleType getDefault() {
            return NONE;
        }
    }
}

