/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.configuration;

import com.turikhay.tlauncher.configuration.SimpleConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

public class LangConfiguration
extends SimpleConfiguration {
    private final Locale[] locales;
    private final Properties[] prop;
    private int i;

    public LangConfiguration(Locale[] locales, Locale select) throws IOException {
        if (locales == null) {
            throw new NullPointerException();
        }
        int size = locales.length;
        this.locales = locales;
        this.prop = new Properties[size];
        int i = 0;
        while (i < size) {
            Locale locale = locales[i];
            if (locale == null) {
                throw new NullPointerException("Locale at #" + i + " is NULL!");
            }
            String localeName = locale.toString();
            InputStream stream = this.getClass().getResourceAsStream("/lang/" + localeName + ".ini");
            if (stream == null) {
                throw new IOException("Cannot find locale file for locale: " + localeName);
            }
            this.prop[i] = LangConfiguration.loadFromStream(stream);
            if (localeName.equals("en_US")) {
                LangConfiguration.copyProperties(this.prop[i], this.properties, true);
            }
            ++i;
        }
        this.setSelected(select);
    }

    public Locale[] getLocales() {
        return this.locales;
    }

    public Locale getSelected() {
        return this.locales[this.i];
    }

    public void setSelected(Locale select) {
        if (select == null) {
            throw new NullPointerException();
        }
        int i = 0;
        while (i < this.locales.length) {
            if (this.locales[i].equals(select)) {
                this.i = i;
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("Cannot find Locale:" + select);
    }

    public String nget(String key) {
        if (key == null) {
            return null;
        }
        String value = this.prop[this.i].getProperty(key);
        if (value == null) {
            return this.getDefault(key);
        }
        return value;
    }

    @Override
    public String get(String key) {
        String value = this.nget(key);
        if (value == null) {
            return key;
        }
        return value;
    }

    public String nget(String key, Object ... vars) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        String[] variables = LangConfiguration.checkVariables(vars);
        int i = 0;
        while (i < variables.length) {
            value = value.replace("%" + i, variables[i]);
            ++i;
        }
        return value;
    }

    public String get(String key, Object ... vars) {
        String value = this.nget(key, vars);
        if (value == null) {
            return key;
        }
        return value;
    }

    @Override
    public void set(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDefault(String key) {
        return super.get(key);
    }

    public static String[] checkVariables(Object[] check) {
        if (check == null) {
            throw new NullPointerException();
        }
        if (check.length == 1 && check[0] == null) {
            return new String[0];
        }
        String[] string = new String[check.length];
        int i = 0;
        while (i < check.length) {
            if (check[i] == null) {
                throw new NullPointerException("Variable at index " + i + " is NULL!");
            }
            string[i] = check[i].toString();
            ++i;
        }
        return string;
    }
}

