/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.downloader;

import com.turikhay.tlauncher.downloader.DownloadableContainer;
import com.turikhay.tlauncher.handlers.DownloadableHandler;
import com.turikhay.util.FileUtil;
import com.turikhay.util.U;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.launcher.Http;

public class Downloadable {
    public static final String DEFAULT_CHECKSUM_ALGORITHM = "SHA-1";
    private List<DownloadableHandler> handlers = new ArrayList<DownloadableHandler>();
    private URL url;
    private File destination;
    private File[] copies;
    private DownloadableContainer container;
    private boolean forced;
    private boolean fast;
    private long time;
    private long size;
    protected Throwable error;

    public Downloadable(URL url, File destination, File[] copies, boolean force) {
        this.url = url;
        this.destination = destination;
        this.copies = copies;
        this.forced = force;
    }

    public Downloadable(String url, File destination, File[] copies, boolean force) throws MalformedURLException {
        this(new URL(Http.encode(url)), destination, copies, force);
    }

    public Downloadable(String url, File destination, boolean force) throws MalformedURLException {
        this(url, destination, new File[0], force);
    }

    public Downloadable(URL url, boolean force) {
        this.url = url;
        this.forced = force;
    }

    public Downloadable(String url, File destination) throws MalformedURLException {
        this(url, destination, false);
    }

    public Downloadable(URL url) {
        this(url, false);
    }

    public Downloadable(URL url, File destination) {
        this(url, destination, null, false);
    }

    public URL getURL() {
        return this.url;
    }

    public File getDestination() {
        return this.destination;
    }

    public File[] getAdditionalDestinations() {
        return this.copies;
    }

    public String getHash(String algorithm) {
        return FileUtil.getChecksum(this.destination, algorithm);
    }

    public String getFilename() {
        return Http.decode(FileUtil.getFilename(this.url));
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isForced() {
        return this.forced;
    }

    public boolean hasContainter() {
        return this.container != null;
    }

    public DownloadableContainer getContainer() {
        return this.container;
    }

    public long getTime() {
        return this.time;
    }

    public long getSize() {
        return this.size;
    }

    public boolean getFast() {
        return this.fast;
    }

    public void onStart() {
        for (DownloadableHandler h : this.handlers) {
            h.onStart();
        }
    }

    public void onComplete() {
        for (DownloadableHandler h : this.handlers) {
            h.onComplete();
        }
    }

    public void onError() {
        for (DownloadableHandler h : this.handlers) {
            h.onCompleteError();
        }
    }

    public void onAbort() {
        for (DownloadableHandler h : this.handlers) {
            h.onAbort();
        }
    }

    public void addHandler(DownloadableHandler newhandler) {
        this.handlers.add(newhandler);
    }

    void setError(Throwable e) {
        this.error = e;
    }

    void setContainer(DownloadableContainer newcontainer) {
        this.container = newcontainer;
    }

    public void setURL(URL newurl) {
        this.url = newurl;
    }

    public void setURL(String newurl) throws MalformedURLException {
        this.url = new URL(newurl);
    }

    public void setDestination(File newdestination) {
        this.destination = newdestination;
    }

    public void setAdditionalDestinations(File[] newdestinations) {
        this.copies = newdestinations;
    }

    public void setForced(boolean newforced) {
        this.forced = newforced;
    }

    public void setTime(long ms) {
        this.time = ms;
    }

    public void setSize(long b) {
        this.size = b;
    }

    public void setFast(boolean newfast) {
        this.fast = newfast;
    }

    public HttpURLConnection makeConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        Downloadable.setUp(connection, false);
        String md5 = this.getHash("MD5");
        if (md5 != null) {
            connection.setRequestProperty("If-None-Match", md5);
        }
        return connection;
    }

    public String toString() {
        String r = "{";
        r = String.valueOf(r) + "url=" + (this.url == null ? null : this.url.toExternalForm());
        r = String.valueOf(r) + ",destination=" + this.destination;
        r = String.valueOf(r) + ",additionaldestinations=" + U.toLog(this.copies);
        r = String.valueOf(r) + ",error=" + this.error;
        r = String.valueOf(r) + ",container=" + this.container;
        r = String.valueOf(r) + ",handlers=" + U.toLog(this.handlers);
        r = String.valueOf(r) + ",forced=" + this.forced;
        r = String.valueOf(r) + "}";
        return r;
    }

    public static URLConnection setUp(URLConnection connection, boolean fake) {
        connection.setConnectTimeout(U.getConnectionTimeout());
        connection.setReadTimeout(U.getReadTimeout());
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
        connection.setRequestProperty("Expires", "0");
        connection.setRequestProperty("Pragma", "no-cache");
        if (!fake) {
            return connection;
        }
        connection.setRequestProperty("Accept", "text/html, application/xml;q=0.9, application/xhtml xml, image/png, image/jpeg, image/gif, image/x-xbitmap, */*;q=0.1");
        connection.setRequestProperty("Accept-Language", "en");
        connection.setRequestProperty("Accept-Charset", "iso-8859-1, utf-8, utf-16, *;q=0.1");
        connection.setRequestProperty("Accept-Encoding", "deflate, gzip, x-gzip, identity, *;q=0");
        connection.setRequestProperty("User-Agent", "Opera/9.80 (Windows NT 6.0) Presto/2.12.388 Version/12.16");
        return connection;
    }

    public static URLConnection setUp(URLConnection connection) {
        return Downloadable.setUp(connection, false);
    }

    public static String getEtag(String etag) {
        if (etag == null) {
            return "-";
        }
        if (etag.startsWith("\"") && etag.endsWith("\"")) {
            return etag.substring(1, etag.length() - 1);
        }
        return etag;
    }
}

