/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.downloader;

import com.turikhay.tlauncher.downloader.Downloadable;
import com.turikhay.tlauncher.handlers.DownloadableHandler;
import com.turikhay.tlauncher.ui.console.Console;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DownloadableContainer {
    private List<DownloadableHandler> handlers = Collections.synchronizedList(new ArrayList());
    private Console console;
    private boolean available = true;
    private int remain;
    private int errors;
    List<Downloadable> elems = new ArrayList<Downloadable>();

    public void addAll(Downloadable[] c) {
        Downloadable[] downloadableArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Downloadable d = downloadableArray[n2];
            this.add(d);
            ++n2;
        }
    }

    public void addAll(Collection<Downloadable> c) {
        for (Downloadable d : c) {
            this.add(d);
        }
    }

    public void add(Downloadable d) {
        this.check();
        this.elems.add(d);
        d.setContainer(this);
        ++this.remain;
    }

    public void remove(Downloadable d) {
        this.check();
        this.elems.remove(d);
        d.setContainer(this);
        ++this.remain;
    }

    public List<Downloadable> get() {
        this.check();
        ArrayList<Downloadable> t = new ArrayList<Downloadable>();
        t.addAll(this.elems);
        return t;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void addHandler(DownloadableHandler newhandler) {
        this.check();
        this.handlers.add(newhandler);
    }

    public List<DownloadableHandler> getHandlers() {
        ArrayList<DownloadableHandler> toret = new ArrayList<DownloadableHandler>();
        for (DownloadableHandler h : this.handlers) {
            toret.add(h);
        }
        return toret;
    }

    public void setConsole(Console c) {
        this.console = c;
    }

    public Console getConsole() {
        return this.console;
    }

    public boolean hasConsole() {
        return this.console != null;
    }

    void log(Object ... obj) {
        if (this.console != null) {
            this.console.log(obj);
        }
    }

    void onError() {
        ++this.errors;
        this.onFileComplete();
    }

    void onStart() {
        for (DownloadableHandler h : this.handlers) {
            h.onStart();
        }
    }

    void onAbort() {
        for (DownloadableHandler h : this.handlers) {
            h.onAbort();
        }
    }

    void onFileComplete() {
        --this.remain;
        if (this.remain != 0) {
            return;
        }
        if (this.errors > 0) {
            for (DownloadableHandler h : this.handlers) {
                h.onCompleteError();
            }
        } else {
            for (DownloadableHandler h : this.handlers) {
                h.onComplete();
            }
        }
    }

    public int getErrors() {
        return this.errors;
    }

    private void check() {
        if (this.available) {
            return;
        }
        throw new IllegalStateException("DownloadableContainer is unavailable!");
    }
}

