/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.downloader;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.configuration.Configuration;
import com.turikhay.tlauncher.downloader.DownloadListener;
import com.turikhay.tlauncher.downloader.Downloadable;
import com.turikhay.tlauncher.downloader.DownloadableContainer;
import com.turikhay.tlauncher.downloader.DownloaderThread;
import com.turikhay.util.U;
import java.util.ArrayList;
import java.util.List;

public class Downloader
extends Thread {
    private final int limitThreads = 10;
    public final String name;
    private int maxThreads;
    private int minTries;
    private int maxTries;
    private boolean launched;
    private boolean available = true;
    private boolean list_ = true;
    private boolean listeners_ = true;
    private DownloaderThread[] threads;
    private List<Downloadable> list = new ArrayList<Downloadable>();
    private List<Downloadable> queue = new ArrayList<Downloadable>();
    private List<DownloadListener> listeners = new ArrayList<DownloadListener>();
    private int[] remain;
    private int[] progress;
    private double[] speed;
    private int av_progress;
    private int runningThreads;
    private double av_speed;

    public Downloader(TLauncher tlauncher) {
        this.name = "Tl";
        this.loadConfiguration(tlauncher.getSettings());
        this.threads = new DownloaderThread[10];
        this.start();
    }

    public Downloader(String name, int minTries, int maxTries, int threads) {
        this.name = name;
        this.maxThreads = threads;
        this.minTries = minTries;
        this.maxThreads = maxTries;
        this.threads = new DownloaderThread[10];
        this.start();
    }

    public Downloader(int minTries, int maxTries, int threads) {
        this("", minTries, maxTries, threads);
    }

    @Override
    public void run() {
        int i;
        this.check();
        while (!this.launched) {
            this.sleepFor(500L);
        }
        while (!this.list_) {
            this.sleepFor(100L);
        }
        this.available = false;
        this.list_ = false;
        this.list.addAll(this.queue);
        this.queue.clear();
        this.runningThreads = 0;
        this.av_progress = 0;
        this.remain = new int[this.maxThreads];
        this.progress = new int[this.maxThreads];
        this.speed = new double[this.maxThreads];
        int len = this.list.size();
        int each = U.getMaxMultiply(len, this.maxThreads);
        int x = 0;
        int y = -1;
        if (len > 0) {
            this.onDownloaderStart(len);
        }
        while (len > 0) {
            i = 0;
            while (i < this.maxThreads) {
                ++y;
                ++this.runningThreads;
                len -= each;
                int n = i;
                this.remain[n] = this.remain[n] + each;
                DownloaderThread curthread = this.threads[i];
                if (curthread == null) {
                    curthread = this.threads[i] = new DownloaderThread(this, i);
                }
                y = x;
                while (y < x + each) {
                    curthread.add(this.list.get(y));
                    ++y;
                }
                x = y;
                if (len == 0) break;
                ++i;
            }
            each = U.getMaxMultiply(len, this.maxThreads);
        }
        i = 0;
        while (i < this.maxThreads) {
            if (this.threads[i] != null) {
                this.threads[i].startLaunch();
            }
            ++i;
        }
        this.list.clear();
        this.list_ = true;
        this.launched = false;
        while (!this.launched) {
            this.sleepFor(500L);
        }
        while (!this.list_) {
            this.sleepFor(100L);
        }
        this.list_ = false;
        this.list.addAll(this.queue);
        this.queue.clear();
        this.list_ = true;
        this.available = true;
        this.run();
    }

    public void add(Downloadable d) {
        while (!this.list_) {
            this.sleepFor(100L);
        }
        this.list_ = false;
        if (this.available) {
            this.list.add(d);
        } else {
            this.queue.add(d);
        }
        this.list_ = true;
    }

    public void add(DownloadableContainer c) {
        while (!this.list_) {
            this.sleepFor(100L);
        }
        this.list_ = false;
        if (this.available) {
            this.list.addAll(c.elems);
        } else {
            this.queue.addAll(c.elems);
        }
        this.list_ = true;
    }

    public void addListener(DownloadListener l) {
        while (!this.listeners_) {
            this.sleepFor(100L);
        }
        this.listeners_ = false;
        this.listeners.add(l);
        this.listeners_ = true;
    }

    public void removeListener(DownloadListener l) {
        while (!this.listeners_) {
            this.sleepFor(100L);
        }
        this.listeners_ = false;
        this.listeners.remove(l);
        this.listeners_ = true;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isLaunched() {
        return this.launched;
    }

    public int getRemaining() {
        return U.getSum(this.remain);
    }

    public void startLaunch() {
        this.launched = true;
    }

    public void stopLaunch() {
        DownloaderThread[] downloaderThreadArray = this.threads;
        int n = this.threads.length;
        int n2 = 0;
        while (n2 < n) {
            DownloaderThread thread = downloaderThreadArray[n2];
            if (thread != null) {
                thread.stopLaunch();
            }
            ++n2;
        }
        boolean has = true;
        block1: while (has) {
            has = false;
            DownloaderThread[] downloaderThreadArray2 = this.threads;
            int n3 = this.threads.length;
            n = 0;
            while (n < n3) {
                DownloaderThread thread = downloaderThreadArray2[n];
                if (thread != null && !thread.isAvailable()) {
                    has = true;
                    continue block1;
                }
                ++n;
            }
        }
        U.gc();
        for (DownloadListener l : this.listeners) {
            l.onDownloaderAbort(this);
        }
    }

    public int getMinTries() {
        return this.minTries;
    }

    public void setMinTries(int i) {
        this.minTries = i;
    }

    public int getMaxTries() {
        return this.maxTries;
    }

    public void setMaxTries(int i) {
        this.maxTries = i;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int i) {
        if (i > 10) {
            throw new IllegalArgumentException("Thread limit exceed!");
        }
        this.maxThreads = i;
    }

    void onDownloaderStart(int files) {
        for (DownloadListener l : this.listeners) {
            l.onDownloaderStart(this, files);
        }
    }

    void onDownloaderStop() {
        for (DownloadListener l : this.listeners) {
            l.onDownloaderComplete(this);
        }
    }

    void onStart(int id, Downloadable d) {
    }

    void onError(int id, Downloadable d) {
        int n = id;
        this.remain[n] = this.remain[n] - 1;
        Throwable error = this.threads[id].getError();
        for (DownloadListener l : this.listeners) {
            l.onDownloaderError(this, d, error);
        }
    }

    void onProgress(int id, int curprogress, double curspeed) {
        this.progress[id] = curprogress;
        this.speed[id] = curspeed;
        int old_progress = this.av_progress;
        this.av_progress = U.getAverage(this.progress, this.runningThreads);
        if (this.av_progress == old_progress) {
            return;
        }
        this.av_speed = U.getSum(this.speed);
        for (DownloadListener l : this.listeners) {
            l.onDownloaderProgress(this, this.av_progress, this.av_speed);
        }
    }

    void onComplete(int id, Downloadable d) {
        int n = id;
        this.remain[n] = this.remain[n] - 1;
        for (DownloadListener l : this.listeners) {
            l.onDownloaderFileComplete(this, d);
        }
        int[] nArray = this.remain;
        int n2 = this.remain.length;
        int n3 = 0;
        while (n3 < n2) {
            int curremain = nArray[n3];
            if (curremain != 0) {
                return;
            }
            ++n3;
        }
        for (DownloadListener l : this.listeners) {
            l.onDownloaderComplete(this);
        }
    }

    private void check() {
        if (this.available) {
            return;
        }
        throw new IllegalStateException("Downloader is unavailable!");
    }

    private void sleepFor(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadConfiguration(Configuration settings) {
        int[] conf = settings.getConnectionQuality().getConfiguration();
        this.setMinTries(conf[0]);
        this.setMaxTries(conf[1]);
        this.setMaxThreads(conf[2]);
    }
}

