/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.minecraft;

import com.turikhay.tlauncher.minecraft.CrashSignature;
import com.turikhay.tlauncher.ui.alert.Alert;
import com.turikhay.tlauncher.ui.loc.Localizable;
import com.turikhay.util.U;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.launcher.OperatingSystem;

public class Crash {
    private String file;
    private List<CrashSignature> signatures = new ArrayList<CrashSignature>();

    void addSignature(CrashSignature sign) {
        this.signatures.add(sign);
    }

    void removeSignature(CrashSignature sign) {
        this.signatures.remove(sign);
    }

    void setFile(String path) {
        this.file = path;
    }

    public String getFile() {
        return this.file;
    }

    public List<CrashSignature> getSignatures() {
        return Collections.unmodifiableList(this.signatures);
    }

    public boolean hasSignature(CrashSignature s) {
        return this.signatures.contains(s);
    }

    public boolean isRecognized() {
        return !this.signatures.isEmpty();
    }

    public static void handle(Crash crash) {
        String p = "crash.";
        String title = Localizable.get(String.valueOf(p) + "title");
        String report = crash.getFile();
        if (!crash.isRecognized()) {
            Alert.showError(title, Localizable.get(String.valueOf(p) + "unknown"), null);
        } else {
            for (CrashSignature sign : crash.getSignatures()) {
                String path = sign.path;
                String message = Localizable.get(String.valueOf(p) + path);
                String url = Localizable.get(String.valueOf(p) + path + ".url");
                URI uri = U.makeURI(url);
                if (uri != null) {
                    if (!Alert.showQuestion(title, message, report, false)) continue;
                    OperatingSystem.openLink(uri);
                    continue;
                }
                Alert.showMessage(title, message, report);
            }
        }
        if (report == null) {
            return;
        }
        if (Alert.showQuestion(String.valueOf(p) + "store", false)) {
            U.log("Removing crash report...");
            File file = new File(report);
            if (!file.exists()) {
                U.log("File is already removed. LOL.");
            } else {
                try {
                    if (!file.delete()) {
                        throw new Exception("file.delete() returned false");
                    }
                }
                catch (Exception e) {
                    U.log("Can't delete crash report file. Okay.");
                    Alert.showAsyncMessage(String.valueOf(p) + "store.failed", e);
                    return;
                }
                U.log("Yay, crash report file doesn't exist by now.");
            }
            Alert.showAsyncMessage(String.valueOf(p) + "store.success");
        }
    }
}

