/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.minecraft;

import com.turikhay.tlauncher.minecraft.Crash;
import com.turikhay.tlauncher.minecraft.CrashSignature;
import com.turikhay.tlauncher.minecraft.FakeCrashSignature;
import com.turikhay.tlauncher.minecraft.MinecraftLauncher;
import com.turikhay.util.U;
import com.turikhay.util.logger.PrintLogger;
import com.turikhay.util.logger.StringStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CrashDescriptor {
    final String prefix = "[CrashDescriptor]";
    static final String forge_prefix = "^(?:[0-9-]+ [0-9:]+ \\[[\\w]+\\]\\ {0,1}\\[{0,1}[\\w]*\\]{0,1}\\ {0,1}){0,1}";
    static final Pattern crash_pattern = Pattern.compile("^.*[\\#\\@\\!\\@\\#][ ]Game[ ]crashed!.+[\\#\\@\\!\\@\\#][ ](.+)$");
    static final Pattern start_crash_report_pattern = Pattern.compile("^(?:[0-9-]+ [0-9:]+ \\[[\\w]+\\]\\ {0,1}\\[{0,1}[\\w]*\\]{0,1}\\ {0,1}){0,1}---- Minecraft Crash Report ----");
    static final CrashSignature[] signatures = CrashDescriptor.initSigns();
    private final PrintLogger context;
    private final StringStream stream;

    CrashDescriptor(MinecraftLauncher launcher) {
        this.context = launcher.getLogger();
        this.stream = launcher.getStream();
    }

    CrashDescriptor(String version, StringStream stream) {
        this.context = null;
        this.stream = stream;
    }

    public Crash scan(int exit) {
        Crash crash = new Crash();
        String[] lines = this.stream.getOutput().split("\n");
        int i = lines.length - 1;
        while (i > -1) {
            String line = lines[i];
            Matcher startM = start_crash_report_pattern.matcher(line);
            if (startM.matches()) {
                this.log("Will not search further - start of crash report exceed.");
                break;
            }
            Matcher fileM = crash_pattern.matcher(line);
            if (fileM.matches()) {
                crash.setFile(fileM.group(1));
            } else {
                CrashSignature[] crashSignatureArray = signatures;
                int n = signatures.length;
                int n2 = 0;
                while (n2 < n) {
                    CrashSignature sign = crashSignatureArray[n2];
                    if (sign.match(line)) {
                        if (sign instanceof FakeCrashSignature) {
                            this.log("Minecraft closed with an illegal exit code not due to error. Cancelling.");
                            this.log("Catched by signature:", sign.name);
                            return null;
                        }
                        if (sign.exitcode == 0 || sign.exitcode == exit) {
                            this.log("Signature \"" + sign.name + "\" matches!");
                            if (!crash.hasSignature(sign)) {
                                crash.addSignature(sign);
                            }
                        }
                    }
                    ++n2;
                }
            }
            --i;
        }
        return crash;
    }

    public static boolean parseExit(int code) {
        return code == 0;
    }

    private static CrashSignature[] initSigns() {
        CrashSignature[] r = new CrashSignature[]{new CrashSignature(0, "^(?:[0-9-]+ [0-9:]+ \\[[\\w]+\\]\\ {0,1}\\[{0,1}[\\w]*\\]{0,1}\\ {0,1}){0,1}[\\s]*org\\.lwjgl\\.LWJGLException\\: Pixel format not accelerated", "Old graphics driver", "opengl"), new CrashSignature(0, "^(?:[0-9-]+ [0-9:]+ \\[[\\w]+\\]\\ {0,1}\\[{0,1}[\\w]*\\]{0,1}\\ {0,1}){0,1}(?:Exception in thread \".*\" ){0,1}java\\.lang\\.(?:Error|NoClass|Exception|Error|Throwable|Illegal){1}.+", "Probably modified JAR", "invalid-modify"), new CrashSignature(1, "Exception in thread \"main\" java.lang.SecurityException: SHA1 digest error for .+", "Undeleted META-INF", "meta-inf"), new CrashSignature(1, "Error: Could not find or load main class .+$", "Missing main class", "missing-main"), new FakeCrashSignature(1, "^(?:[0-9-]+ [0-9:]+ \\[[\\w]+\\]\\ {0,1}\\[{0,1}[\\w]*\\]{0,1}\\ {0,1}){0,1}Someone is closing me!", "Direct close bug")};
        return r;
    }

    void log(Object ... w) {
        if (this.context != null) {
            this.context.log("[CrashDescriptor]", w);
        }
        U.log("[CrashDescriptor]", w);
    }
}

