/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.minecraft.auth;

import com.google.gson.Gson;
import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.minecraft.auth.Account;
import com.turikhay.tlauncher.minecraft.auth.AuthenticationRequest;
import com.turikhay.tlauncher.minecraft.auth.AuthenticationResponse;
import com.turikhay.tlauncher.minecraft.auth.AuthenticatorException;
import com.turikhay.tlauncher.minecraft.auth.AuthenticatorListener;
import com.turikhay.tlauncher.minecraft.auth.AuthenticatorService;
import com.turikhay.tlauncher.minecraft.auth.InvalidCredentialsException;
import com.turikhay.tlauncher.minecraft.auth.RefreshRequest;
import com.turikhay.tlauncher.minecraft.auth.RefreshResponse;
import com.turikhay.tlauncher.minecraft.auth.Request;
import com.turikhay.tlauncher.minecraft.auth.Response;
import com.turikhay.tlauncher.minecraft.auth.UserMigratedException;
import com.turikhay.util.U;
import com.turikhay.util.async.AsyncThread;
import java.io.IOException;
import java.net.URL;
import java.util.UUID;
import net.minecraft.launcher.Http;
import org.apache.commons.lang3.StringUtils;

public class Authenticator {
    private static final URL ROUTE_AUTHENTICATE = Http.constantURL("https://authserver.mojang.com/authenticate");
    private static final URL ROUTE_REFRESH = Http.constantURL("https://authserver.mojang.com/refresh");
    public final Account account;
    private final Authenticator instance;
    private final Gson gson;

    public Authenticator(Account account) {
        if (account == null) {
            throw new NullPointerException();
        }
        this.instance = this;
        this.gson = new Gson();
        this.account = account;
    }

    public UUID getClientToken() {
        return TLauncher.getInstance().getProfileManager().getClientToken();
    }

    private void setClientToken(String uuid) {
        TLauncher.getInstance().getProfileManager().setClientToken(uuid);
    }

    public void pass() throws AuthenticatorException {
        if (!this.account.hasLicense()) {
            throw new IllegalArgumentException("Invalid account type!");
        }
        if (this.account.getPassword() == null && this.account.getAccessToken() == null) {
            throw new AuthenticatorException("Password and token are NULL!");
        }
        this.log("Staring to authenticate:");
        this.log("hasUsername:", this.account.getUsername());
        this.log("hasPassword:", this.account.getPassword() != null);
        this.log("hasAccessToken:", this.account.getAccessToken() != null);
        if (this.account.getPassword() == null) {
            this.tokenLogin();
        } else {
            this.passwordLogin();
        }
        this.log("Log in successful!");
        this.log("hasUUID:", this.account.getUUID() != null);
        this.log("hasAccessToken:", this.account.getAccessToken() != null);
        this.log("hasProfiles:", this.account.getProfiles() != null);
        this.log("hasProfile:", this.account.getProfiles() != null);
        this.log("hasProperties:", this.account.getProperties() != null);
    }

    public boolean pass(AuthenticatorListener l) {
        if (l != null) {
            l.onAuthPassing(this.instance);
        }
        try {
            this.instance.pass();
        }
        catch (Exception e) {
            this.log("Cannot authenticate:", e);
            if (l != null) {
                l.onAuthPassingError(this.instance, e);
            }
            return false;
        }
        if (l != null) {
            l.onAuthPassed(this.instance);
        }
        return true;
    }

    public void asyncPass(final AuthenticatorListener l) {
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                Authenticator.this.pass(l);
            }
        });
    }

    protected void passwordLogin() throws AuthenticatorException {
        this.log("Loggining in with password");
        AuthenticationRequest request = new AuthenticationRequest(this);
        AuthenticationResponse response = this.makeRequest(ROUTE_AUTHENTICATE, request, AuthenticationResponse.class);
        this.account.setUserID(response.getUserID() != null ? response.getUserID() : this.account.getUsername());
        this.account.setAccessToken(response.getAccessToken());
        this.account.setProfiles(response.getAvailableProfiles());
        this.account.setProfile(response.getSelectedProfile());
        this.account.setUser(response.getUser());
        this.setClientToken(response.getClientToken());
        if (response.getSelectedProfile() != null) {
            this.account.setUUID(response.getSelectedProfile().getId());
            this.account.setDisplayName(response.getSelectedProfile().getName());
        }
    }

    protected void tokenLogin() throws AuthenticatorException {
        this.log("Loggining in with token");
        RefreshRequest request = new RefreshRequest(this);
        RefreshResponse response = this.makeRequest(ROUTE_REFRESH, request, RefreshResponse.class);
        this.setClientToken(response.getClientToken());
        this.account.setAccessToken(response.getAccessToken());
        this.account.setProfile(response.getSelectedProfile());
        this.account.setUser(response.getUser());
    }

    protected <T extends Response> T makeRequest(URL url, Request input, Class<T> classOfT) throws AuthenticatorException {
        String jsonResult;
        try {
            jsonResult = input == null ? AuthenticatorService.performGetRequest(url) : AuthenticatorService.performPostRequest(url, this.gson.toJson(input), "application/json");
        }
        catch (IOException e) {
            throw new AuthenticatorException("Error making request, uncaught IOException", "unreachable", e);
        }
        Response result = (Response)this.gson.fromJson(jsonResult, classOfT);
        if (result == null) {
            return null;
        }
        if (StringUtils.isBlank(result.getError())) {
            return (T)result;
        }
        if ("UserMigratedException".equals(result.getCause())) {
            throw new UserMigratedException();
        }
        if (result.getError().equals("ForbiddenOperationException")) {
            throw new InvalidCredentialsException();
        }
        throw new AuthenticatorException(result.getErrorMessage(), "internal");
    }

    protected void log(Object ... o) {
        U.log("[AUTH]", o);
    }
}

