/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.minecraft.auth;

import com.turikhay.util.U;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;

public class AuthenticatorService {
    protected static void log(Object ... o) {
        U.log("[AUTHSERV]", o);
    }

    protected static void debug(Object ... o) {
    }

    protected static HttpURLConnection createUrlConnection(URL url) throws IOException {
        Validate.notNull(url);
        AuthenticatorService.debug("Opening connection to " + url);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(U.getConnectionTimeout());
        connection.setReadTimeout(U.getReadTimeout());
        connection.setUseCaches(false);
        return connection;
    }

    public static String performPostRequest(URL url, String post, String contentType) throws IOException {
        Validate.notNull(url);
        Validate.notNull(post);
        Validate.notNull(contentType);
        HttpURLConnection connection = AuthenticatorService.createUrlConnection(url);
        byte[] postAsBytes = post.getBytes(Charsets.UTF_8);
        connection.setRequestProperty("Content-Type", String.valueOf(contentType) + "; charset=utf-8");
        connection.setRequestProperty("Content-Length", "" + postAsBytes.length);
        connection.setDoOutput(true);
        AuthenticatorService.debug("Writing POST data to " + url + ": " + post);
        OutputStream outputStream = null;
        try {
            outputStream = connection.getOutputStream();
            IOUtils.write(postAsBytes, outputStream);
        }
        finally {
            IOUtils.closeQuietly(outputStream);
        }
        AuthenticatorService.debug("Reading data from " + url);
        InputStream inputStream = null;
        try {
            inputStream = connection.getInputStream();
            String result = IOUtils.toString(inputStream, Charsets.UTF_8);
            AuthenticatorService.debug("Successful read, server response was " + connection.getResponseCode());
            AuthenticatorService.debug("Response: " + result);
            String string = result;
            return string;
        }
        catch (IOException e) {
            IOUtils.closeQuietly(inputStream);
            inputStream = connection.getErrorStream();
            if (inputStream != null) {
                AuthenticatorService.debug("Reading error page from " + url);
                String result = IOUtils.toString(inputStream, Charsets.UTF_8);
                AuthenticatorService.debug("Successful read, server response was " + connection.getResponseCode());
                AuthenticatorService.debug("Response: " + result);
                String string = result;
                return string;
            }
            AuthenticatorService.debug("Request failed", e);
            throw e;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public static String performGetRequest(URL url) throws IOException {
        Validate.notNull(url);
        HttpURLConnection connection = AuthenticatorService.createUrlConnection(url);
        AuthenticatorService.debug("Reading data from " + url);
        InputStream inputStream = null;
        try {
            inputStream = connection.getInputStream();
            String result = IOUtils.toString(inputStream, Charsets.UTF_8);
            AuthenticatorService.debug("Successful read, server response was " + connection.getResponseCode());
            AuthenticatorService.debug("Response: " + result);
            String string = result;
            return string;
        }
        catch (IOException e) {
            IOUtils.closeQuietly(inputStream);
            inputStream = connection.getErrorStream();
            if (inputStream != null) {
                AuthenticatorService.debug("Reading error page from " + url);
                String result = IOUtils.toString(inputStream, Charsets.UTF_8);
                AuthenticatorService.debug("Successful read, server response was " + connection.getResponseCode());
                AuthenticatorService.debug("Response: " + result);
                String string = result;
                return string;
            }
            AuthenticatorService.debug("Request failed", e);
            throw e;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public static URL constantURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new Error("Couldn't create constant for " + url, ex);
        }
    }

    public static String buildQuery(Map<String, Object> query) {
        if (query == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : query.entrySet()) {
            if (builder.length() > 0) {
                builder.append('&');
            }
            try {
                builder.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                AuthenticatorService.log("Unexpected exception building query", e);
            }
            if (entry.getValue() == null) continue;
            builder.append('=');
            try {
                builder.append(URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                AuthenticatorService.log("Unexpected exception building query", e);
            }
        }
        return builder.toString();
    }

    public static URL concatenateURL(URL url, String query) {
        try {
            if (url.getQuery() != null && url.getQuery().length() > 0) {
                return new URL(url.getProtocol(), url.getHost(), String.valueOf(url.getFile()) + "&" + query);
            }
            return new URL(url.getProtocol(), url.getHost(), String.valueOf(url.getFile()) + "?" + query);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Could not concatenate given URL with GET arguments!", ex);
        }
    }
}

