/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.configuration.Configuration;
import com.turikhay.tlauncher.configuration.LangConfiguration;
import com.turikhay.tlauncher.ui.MainPane;
import com.turikhay.tlauncher.ui.alert.Alert;
import com.turikhay.tlauncher.ui.console.Console;
import com.turikhay.tlauncher.ui.images.ImageCache;
import com.turikhay.tlauncher.ui.loc.LocalizableComponent;
import com.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import com.turikhay.util.U;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class TLauncherFrame
extends JFrame {
    private static final long serialVersionUID = 5077131443679431434L;
    private static final List<Image> favicons = new ArrayList<Image>();
    private final TLauncherFrame instance = this;
    public final TLauncher tlauncher;
    public final Configuration settings;
    public final LangConfiguration lang;
    private final int[] windowSize;
    public final MainPane mp;

    public TLauncherFrame(TLauncher t) {
        this.tlauncher = t;
        this.settings = t.getSettings();
        this.lang = t.getLang();
        this.windowSize = this.settings.getWindowSize();
        TLauncherFrame.initLookAndFeel();
        TLauncherFrame.initFontSize();
        this.setUILocale();
        this.setWindowSize();
        this.setWindowTitle();
        this.setIconImages(TLauncherFrame.getFavicons());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TLauncherFrame.this.instance.setVisible(false);
                TLauncher.kill();
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                TLauncherFrame.this.mp.onResize();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                TLauncherFrame.this.instance.validate();
                TLauncherFrame.this.instance.repaint();
                TLauncherFrame.this.instance.toFront();
                TLauncherFrame.this.mp.showBackground();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                TLauncherFrame.this.mp.hideBackground();
            }
        });
        TLauncherFrame.log("Preparing main pane...");
        this.mp = new MainPane(this);
        this.add(this.mp);
        TLauncherFrame.log("Packing main frame...");
        this.pack();
        TLauncherFrame.log("Resizing main pane...");
        this.mp.onResize();
        this.mp.showBackground();
        this.setVisible(true);
        if (this.settings.isFirstRun()) {
            Alert.showAsyncWarning("firstrun");
        }
    }

    public void updateLocales() {
        try {
            this.tlauncher.reloadLocale();
        }
        catch (Exception e) {
            TLauncherFrame.log("Cannot reload settings!", e);
            return;
        }
        Console.updateLocale();
        LocalizableMenuItem.updateLocales();
        this.setWindowTitle();
        this.setUILocale();
        TLauncherFrame.updateContainer(this, true);
    }

    private void setWindowSize() {
        Dimension sizes = new Dimension(this.windowSize[0], this.windowSize[1]);
        this.setPreferredSize(sizes);
        this.setMinimumSize(sizes);
        this.setLocationRelativeTo(null);
    }

    private void setWindowTitle() {
        String translator = this.lang.nget("translator");
        String copyright = "(by turikhay" + (translator != null ? ", translated by " + translator : "") + ")";
        String brand = String.valueOf(TLauncher.getBrand()) + " " + TLauncher.getVersion();
        this.setTitle("TLauncher " + brand + " " + copyright);
    }

    private void setUILocale() {
        UIManager.put("OptionPane.yesButtonText", this.lang.nget("ui.yes"));
        UIManager.put("OptionPane.noButtonText", this.lang.nget("ui.no"));
        UIManager.put("OptionPane.cancelButtonText", this.lang.nget("ui.cancel"));
    }

    public static void initFontSize() {
        try {
            UIDefaults defaults = UIManager.getDefaults();
            int minSize = 12;
            int maxSize = 14;
            Enumeration e = defaults.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = defaults.get(key);
                if (!(value instanceof Font)) continue;
                Font font = (Font)value;
                int size = font.getSize();
                if (size < minSize) {
                    size = minSize;
                } else if (size > maxSize) {
                    size = maxSize;
                }
                if (value instanceof FontUIResource) {
                    defaults.put(key, new FontUIResource(font.getName(), font.getStyle(), size));
                    continue;
                }
                defaults.put(key, new Font(font.getName(), font.getStyle(), size));
            }
        }
        catch (Exception e) {
            TLauncherFrame.log("Cannot change font sizes!", e);
        }
    }

    public static void initLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            TLauncherFrame.log("Can't set system look and feel.");
            e.printStackTrace();
        }
    }

    public static void updateContainer(Container container, boolean deep) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof LocalizableComponent) {
                ((LocalizableComponent)((Object)c)).updateLocale();
            }
            if (c instanceof Container && deep) {
                TLauncherFrame.updateContainer((Container)c, true);
            }
            ++n2;
        }
    }

    public static List<Image> getFavicons() {
        if (!favicons.isEmpty()) {
            return Collections.unmodifiableList(favicons);
        }
        int[] sizes = new int[]{256, 128, 96, 64, 48, 32, 24, 16};
        String loaded = "";
        int[] nArray = sizes;
        int n = sizes.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            Image image = ImageCache.getImage("fav" + i + ".png", false);
            if (image != null) {
                loaded = String.valueOf(loaded) + ", " + i + "px";
                favicons.add(image);
            }
            ++n2;
        }
        if (loaded.isEmpty()) {
            TLauncherFrame.log("No favicon is loaded.");
        } else {
            TLauncherFrame.log("Favicons loaded:", loaded.substring(2));
        }
        return favicons;
    }

    public static URL getRes(String uri) {
        return TLauncherFrame.class.getResource(uri);
    }

    private static void log(Object ... o) {
        U.log("[Frame]", o);
    }
}

