/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.alert;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.configuration.LangConfiguration;
import com.turikhay.tlauncher.ui.alert.AlertPanel;
import com.turikhay.util.U;
import com.turikhay.util.async.AsyncThread;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Alert {
    private static final int wrap = 100;
    private static LangConfiguration lang;
    private static String PREFIX;
    private static String DEFAULT_TITLE;
    private static String DEFAULT_MESSAGE;
    private static String MISSING_TITLE;
    private static String MISSING_MESSAGE;
    private static final boolean DEFAULT_EXIT = false;

    static {
        PREFIX = "TLauncher : ";
        DEFAULT_TITLE = "An error occurred";
        DEFAULT_MESSAGE = "An unexpected error occurred";
        MISSING_TITLE = "MISSING TITLE";
        MISSING_MESSAGE = "MISSING MESSAGE";
    }

    public static void showError(String title, String message, Object textarea, Throwable e, boolean exit) {
        JFrame frame = new JFrame();
        String t_title = String.valueOf(PREFIX) + title;
        String t_message = message != null ? "<html><div align=\"justify\">" + Alert.w(message).replace("\n", "<br/>") + "</div></html>" : null;
        String t_throwable = e != null ? Alert.w(U.stackTrace(e)) : null;
        String t_textarea = textarea != null ? Alert.w(textarea.toString()) : null;
        AlertPanel panel = new AlertPanel(t_message);
        if (t_textarea != null) {
            panel.addTextArea(t_textarea);
        }
        if (t_throwable != null) {
            panel.addTextArea(t_throwable);
        }
        frame.requestFocus();
        JOptionPane.showMessageDialog(frame, panel, t_title, 0);
        if (exit) {
            System.exit(1);
        }
    }

    public static void showError(String title, String message, Throwable e) {
        Alert.showError(title, message, null, e, false);
    }

    public static void showError(String message, Throwable e) {
        Alert.showError(DEFAULT_TITLE, message, null, e, false);
    }

    public static void showError(Throwable e, boolean exit) {
        Alert.showError(DEFAULT_TITLE, DEFAULT_MESSAGE, null, e, exit);
    }

    public static void showError(String title, String message, Object textarea) {
        Alert.showError(title, message, textarea, null, false);
    }

    public static void showError(String title, String message) {
        Alert.showError(title, message, null, null, false);
    }

    public static void showError(String path) {
        Alert.showError(Alert.getLocal(String.valueOf(path) + ".title", MISSING_TITLE), Alert.getLocal(path, MISSING_MESSAGE));
    }

    public static void showAsyncError(final String title, final String message, final Object textarea) {
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                Alert.showError(title, message, textarea);
            }
        });
    }

    public static void showWarning(String title, String message, Object textarea) {
        JFrame frame = new JFrame();
        String t_title = String.valueOf(PREFIX) + title;
        String t_message = message != null ? "<html><div align=\"justify\">" + Alert.w(message).replace("\n", "<br/>") + "</div></html>" : null;
        String t_textarea = textarea != null ? Alert.w(textarea.toString()) : null;
        AlertPanel panel = new AlertPanel(t_message);
        if (t_textarea != null) {
            panel.addTextArea(t_textarea);
        }
        frame.requestFocus();
        JOptionPane.showMessageDialog(frame, panel, t_title, 2);
    }

    public static void showAsyncWarning(final String title, final String message, final Object textarea) {
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                Alert.showWarning(title, message, textarea);
            }
        });
    }

    public static void showAsyncWarning(String title, String message) {
        Alert.showAsyncWarning(title, message, null);
    }

    public static void showAsyncWarning(final String path) {
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                Alert.showWarning(path);
            }
        });
    }

    public static void showWarning(String title, String message) {
        Alert.showWarning(title, message, null);
    }

    public static void showWarning(String path) {
        Alert.showWarning(Alert.getLocal(String.valueOf(path) + ".title", MISSING_TITLE), Alert.getLocal(path, MISSING_MESSAGE), null);
    }

    public static boolean showQuestion(String title, String message, Object textarea, boolean force) {
        JFrame frame = new JFrame();
        String t_title = String.valueOf(PREFIX) + title;
        String t_message = message != null ? "<html><div align=\"justify\">" + Alert.w(message).replace("\n", "<br/>") + "</div></html>" : null;
        String t_textarea = textarea != null ? Alert.w(textarea.toString()) : null;
        AlertPanel panel = new AlertPanel(t_message);
        if (t_textarea != null) {
            panel.addTextArea(t_textarea);
        }
        frame.requestFocus();
        boolean result = JOptionPane.showConfirmDialog(frame, panel, t_title, 0) == 0;
        return result;
    }

    public static boolean showQuestion(String path, Object textarea, boolean force) {
        return Alert.showQuestion(Alert.getLocal(String.valueOf(path) + ".title", MISSING_TITLE), Alert.getLocal(path, MISSING_MESSAGE), textarea, force);
    }

    public static boolean showQuestion(String path, boolean force) {
        return Alert.showQuestion(path, null, force);
    }

    public static void showMessage(String title, String message, Object textarea) {
        JFrame frame = new JFrame();
        String t_title = String.valueOf(PREFIX) + title;
        String t_message = message != null ? "<html><div align=\"justify\">" + Alert.w(message).replace("\n", "<br/>") + "</div></html>" : null;
        String t_textarea = textarea != null ? Alert.w(textarea.toString()) : null;
        AlertPanel panel = new AlertPanel(t_message);
        if (t_textarea != null) {
            panel.addTextArea(t_textarea);
        }
        frame.requestFocus();
        JOptionPane.showMessageDialog(frame, panel, t_title, 1);
    }

    public static void showMessage(String path, Object textarea) {
        Alert.showMessage(Alert.getLocal(String.valueOf(path) + ".title", MISSING_TITLE), Alert.getLocal(path, MISSING_MESSAGE), textarea);
    }

    public static void showAsyncMessage(final String path, final Object textarea) {
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                Alert.showMessage(path, textarea);
            }
        });
    }

    public static void showAsyncMessage(String path) {
        Alert.showAsyncMessage(path, null);
    }

    public static void showAsyncMessage(final String title, final String message, final Object textarea) {
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                Alert.showMessage(title, message, textarea);
            }
        });
    }

    private static String getLocal(String path, String message) {
        try {
            if (lang == null) {
                lang = TLauncher.getInstance().getLang();
            }
            return lang.get(path);
        }
        catch (Throwable throwable) {
            return message;
        }
    }

    public static void prepareLocal() {
        DEFAULT_TITLE = Alert.getLocal("alert.error.title", DEFAULT_TITLE);
        DEFAULT_MESSAGE = Alert.getLocal("alert.error.message", DEFAULT_MESSAGE);
    }

    private static String w(String s) {
        return U.w(s, 100);
    }
}

