/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.backgrounds;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.ui.MainPane;
import com.turikhay.tlauncher.ui.backgrounds.LightBackground;
import com.turikhay.util.U;
import com.turikhay.util.async.AsyncThread;
import java.awt.Graphics2D;

public class DayBackground
extends LightBackground {
    private static final long serialVersionUID = -3722426754002999260L;
    public final double MIN = -0.5;
    public final double MAX = 1.5;
    private final int TICK = 100;
    private boolean started;
    private boolean redraw;

    public DayBackground(MainPane main) {
        this(main, U.doubleRandom());
    }

    public DayBackground(MainPane main, double loc) {
        super(main, loc);
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        TLauncher.getInstance().getSettings().set("gui.sun", (Object)true);
        this.started = true;
        this.redraw = true;
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                while (DayBackground.this.started) {
                    DayBackground.this.tick();
                }
            }
        });
        DayBackground.log("Sun has been started");
    }

    @Override
    public void suspend() {
        this.started = false;
        DayBackground.log("Sun has been suspended");
    }

    @Override
    public void stop() {
        TLauncher.getInstance().getSettings().set("gui.sun", (Object)false);
        this.started = false;
        DayBackground.log("Sun has been stopped");
    }

    private void tick() {
        if (!this.isVisible()) {
            return;
        }
        this.sunLocation = this.sunLocation <= -0.5 ? 1.5 : (this.sunLocation -= 0.001);
        long start = System.nanoTime();
        this.repaint();
        long end = System.nanoTime();
        long diff = end - start;
        if (diff > 1000000L) {
            DayBackground.log("Sun is probably lagging (" + diff + " ns > 1000000 ns).");
        }
        U.sleepFor(100L);
    }

    @Override
    public void draw(Graphics2D g, boolean force) {
        if (this.redraw) {
            force = true;
            this.redraw = false;
        }
        super.draw(g, force);
    }

    private static void log(Object ... o) {
        U.log("[DayBackground]", o);
    }
}

