/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.center;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.configuration.Configuration;
import com.turikhay.tlauncher.configuration.LangConfiguration;
import com.turikhay.tlauncher.ui.block.BlockablePanel;
import com.turikhay.tlauncher.ui.center.CenterPanelTheme;
import com.turikhay.tlauncher.ui.center.DefaultCenterPanelTheme;
import com.turikhay.tlauncher.ui.center.TipPanelTheme;
import com.turikhay.tlauncher.ui.loc.LocalizableLabel;
import com.turikhay.tlauncher.ui.swing.Del;
import com.turikhay.util.U;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class CenterPanel
extends BlockablePanel {
    private static final long serialVersionUID = -1975869198322761508L;
    public static final CenterPanelTheme defaultTheme = new DefaultCenterPanelTheme();
    public static final CenterPanelTheme tipTheme = new TipPanelTheme();
    public static final Insets defaultInsets = new Insets(5, 24, 18, 24);
    public static final Insets squareInsets = new Insets(15, 15, 15, 15);
    public static final Insets smallSquareInsets = new Insets(7, 7, 7, 7);
    private final Insets insets;
    private final CenterPanelTheme theme;
    protected final JPanel messagePanel;
    protected final LocalizableLabel messageLabel;
    public final TLauncher tlauncher = TLauncher.getInstance();
    public final Configuration global = this.tlauncher.getSettings();
    public final LangConfiguration lang = this.tlauncher.getLang();

    public CenterPanel() {
        this(null, null);
    }

    public CenterPanel(Insets insets) {
        this(null, insets);
    }

    public CenterPanel(CenterPanelTheme theme, Insets insets) {
        theme = theme == null ? defaultTheme : theme;
        this.theme = theme;
        insets = insets == null ? defaultInsets : insets;
        this.insets = insets;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(theme.getPanelBackground());
        this.messageLabel = new LocalizableLabel("  ");
        this.messageLabel.setFont(this.getFont().deriveFont(1));
        this.messageLabel.setVerticalAlignment(0);
        this.messageLabel.setHorizontalTextPosition(0);
        this.messagePanel = CenterPanel.sepPan(new FlowLayout(), this.messageLabel);
        this.add(Box.createVerticalGlue());
    }

    @Override
    public void paintComponent(Graphics g0) {
        Graphics2D g = (Graphics2D)g0;
        int arc = 32;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getBackground());
        g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), arc, arc);
        g.setColor(this.theme.getBorder());
        int x = 1;
        while (x < 2) {
            g.drawRoundRect(x - 1, x - 1, this.getWidth() - 2 * x + 1, this.getHeight() - 2 * x + 1, arc, arc);
            ++x;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        super.paintComponent(g);
    }

    public CenterPanelTheme getTheme() {
        return this.theme;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    public Del del(int aligment) {
        return new Del(1, aligment, this.theme.getBorder());
    }

    public Del del(int aligment, int width, int height) {
        return new Del(1, aligment, width, height, this.theme.getBorder());
    }

    public void defocus() {
        this.requestFocusInWindow();
    }

    public boolean setError(String message) {
        this.messageLabel.setForeground(this.theme.getFailure());
        this.messageLabel.setText(message == null || message.length() == 0 ? " " : message);
        return false;
    }

    public boolean setMessage(String message) {
        this.messageLabel.setForeground(this.theme.getSuccess());
        this.messageLabel.setText(message == null || message.length() == 0 ? " " : message);
        return true;
    }

    public static JPanel sepPan(LayoutManager manager, Component ... components) {
        BlockablePanel panel = new BlockablePanel(manager);
        panel.setOpaque(false);
        panel.add(components);
        return panel;
    }

    public static JPanel sepPan(Component ... components) {
        return CenterPanel.sepPan(new GridLayout(0, 1), components);
    }

    protected void log(Object ... o) {
        U.log("[" + this.getClass().getSimpleName() + "]", o);
    }
}

