/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.login;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.component.managers.VersionManager;
import com.turikhay.tlauncher.component.managers.VersionManagerListener;
import com.turikhay.tlauncher.minecraft.Crash;
import com.turikhay.tlauncher.minecraft.MinecraftLauncherException;
import com.turikhay.tlauncher.minecraft.MinecraftLauncherListener;
import com.turikhay.tlauncher.minecraft.auth.Authenticator;
import com.turikhay.tlauncher.minecraft.auth.AuthenticatorListener;
import com.turikhay.tlauncher.ui.MainPane;
import com.turikhay.tlauncher.ui.alert.Alert;
import com.turikhay.tlauncher.ui.block.Blocker;
import com.turikhay.tlauncher.ui.center.CenterPanel;
import com.turikhay.tlauncher.ui.login.AccountComboBox;
import com.turikhay.tlauncher.ui.login.AutoLogin;
import com.turikhay.tlauncher.ui.login.CheckBoxPanel;
import com.turikhay.tlauncher.ui.login.LoginException;
import com.turikhay.tlauncher.ui.login.LoginListener;
import com.turikhay.tlauncher.ui.login.LoginWaitException;
import com.turikhay.tlauncher.ui.login.VersionComboBox;
import com.turikhay.tlauncher.ui.login.buttons.ButtonPanel;
import com.turikhay.tlauncher.ui.scenes.DefaultScene;
import com.turikhay.tlauncher.ui.settings.SettingsPanel;
import com.turikhay.tlauncher.updater.Ad;
import com.turikhay.tlauncher.updater.Update;
import com.turikhay.tlauncher.updater.UpdateListener;
import com.turikhay.tlauncher.updater.Updater;
import com.turikhay.tlauncher.updater.UpdaterListener;
import com.turikhay.util.U;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LoginForm
extends CenterPanel
implements MinecraftLauncherListener,
AuthenticatorListener,
VersionManagerListener,
UpdaterListener,
UpdateListener {
    private static final long serialVersionUID = -7539492515708852727L;
    public static final String LOGIN_BLOCK = "login";
    public static final String REFRESH_BLOCK = "refresh";
    public static final String LAUNCH_BLOCK = "launch";
    public static final String AUTH_BLOCK = "auth";
    public static final String UPDATER_BLOCK = "update";
    final List<LoginListener> listeners = new ArrayList<LoginListener>();
    final LoginThread thread;
    public final DefaultScene scene;
    final LoginForm instance = this;
    final SettingsPanel settings;
    final MainPane pane;
    public final AccountComboBox accounts;
    public final VersionComboBox versions;
    public final CheckBoxPanel checkbox;
    public final ButtonPanel buttons;
    public final AutoLogin autologin;

    public LoginForm(DefaultScene scene) {
        this.scene = scene;
        this.settings = scene.settingsForm;
        this.pane = scene.getMainPane();
        this.thread = new LoginThread(this);
        this.autologin = new AutoLogin(this);
        this.accounts = new AccountComboBox(this);
        this.versions = new VersionComboBox(this);
        this.checkbox = new CheckBoxPanel(this);
        this.buttons = new ButtonPanel(this);
        this.listeners.add(this.autologin);
        this.listeners.add(this.checkbox);
        this.listeners.add(this.versions);
        this.listeners.add(this.accounts);
        this.add((Component)this.messagePanel);
        this.add((Component)this.del(0));
        this.add((Component)this.accounts);
        this.add((Component)this.versions);
        this.add((Component)this.del(0));
        this.add((Component)this.checkbox);
        this.add((Component)this.del(0));
        this.add((Component)this.buttons);
        TLauncher.getInstance().getVersionManager().addListener(this);
    }

    private void saveValues() {
        this.log("Saving values...");
        this.global.set("login.account", this.accounts.getAccount().getUsername(), false);
        this.global.set("login.version", this.versions.getVersion().getID(), false);
        this.global.store();
        this.log("Values has been saved!");
    }

    public void callLogin() {
        if (Blocker.isBlocked(this)) {
            this.log("Cannot call login, UI is blocked by:", Blocker.getBlockList(this));
            return;
        }
        this.autologin.setActive(false);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLogin() {
        this.log("Running login process from a thread");
        LoginException error = null;
        boolean success = true;
        List<LoginListener> list = this.listeners;
        synchronized (list) {
            for (LoginListener listener : this.listeners) {
                this.log("Running on a listener", listener.getClass().getSimpleName());
                try {
                    listener.onLogin();
                }
                catch (LoginWaitException wait) {
                    this.log("Catched a wait task from this listener, waiting...");
                    try {
                        wait.getWaitTask().runTask();
                    }
                    catch (LoginException waitError) {
                        this.log("Catched an error on a wait task.");
                        error = waitError;
                    }
                }
                catch (LoginException loginError) {
                    this.log("Catched an error on a listener");
                    error = loginError;
                }
                if (error == null) continue;
                this.log(error);
                success = false;
                break;
            }
            for (LoginListener listener : this.listeners) {
                if (success) {
                    listener.onLoginSuccess();
                    continue;
                }
                listener.onLoginFailed();
            }
        }
        if (error != null) {
            this.log("Login process has ended with an error.");
            return;
        }
        this.log("Login process is OK :)");
        this.saveValues();
        boolean force = this.checkbox.forceupdate.isSelected();
        this.tlauncher.launch(this.instance, force);
        this.checkbox.forceupdate.setSelected(false);
    }

    @Override
    public void block(Object reason) {
        if (!reason.equals(REFRESH_BLOCK)) {
            Blocker.block(this.accounts, reason);
        }
        Blocker.block(reason, this.settings, this.versions, this.checkbox, this.buttons);
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblock(reason, this.settings, this.accounts, this.versions, this.checkbox, this.buttons);
    }

    @Override
    public void onAuthPassing(Authenticator auth) {
        Blocker.block(this, AUTH_BLOCK);
    }

    @Override
    public void onAuthPassingError(Authenticator auth, Throwable e) {
        Blocker.unblock(this, AUTH_BLOCK);
        Throwable cause = e.getCause();
        if (cause != null && e.getCause() instanceof IOException) {
            return;
        }
        throw new LoginException("Cannot auth!");
    }

    @Override
    public void onAuthPassed(Authenticator auth) {
        Blocker.unblock(this, AUTH_BLOCK);
    }

    @Override
    public void onVersionsRefreshing(VersionManager vm) {
        Blocker.block(this, REFRESH_BLOCK);
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager vm) {
        Blocker.unblock(this, REFRESH_BLOCK);
    }

    @Override
    public void onVersionsRefreshed(VersionManager vm) {
        Blocker.unblock(this, REFRESH_BLOCK);
    }

    @Override
    public void onMinecraftCheck() {
        Blocker.block(this, LAUNCH_BLOCK);
    }

    @Override
    public void onMinecraftPrepare() {
    }

    @Override
    public void onMinecraftLaunch() {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.tlauncher.hide();
        this.tlauncher.getVersionManager().asyncRefresh();
        this.tlauncher.getUpdater().asyncFindUpdate();
    }

    @Override
    public void onMinecraftLaunchStop() {
        Blocker.unblock(this, LAUNCH_BLOCK);
    }

    @Override
    public void onMinecraftClose() {
        this.tlauncher.show();
        this.tlauncher.getUpdaterListener().applyDelayedUpdate();
    }

    @Override
    public void onMinecraftKnownError(MinecraftLauncherException knownError) {
        Alert.showError(this.lang.get("launcher.error.title"), this.lang.get(knownError.getLangpath()), knownError.getReplace());
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.tlauncher.show();
    }

    @Override
    public void onMinecraftError(Throwable unknownError) {
        Alert.showError(this.lang.get("launcher.error.title"), this.lang.get("launcher.error.unknown"), unknownError);
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.tlauncher.show();
    }

    @Override
    public void onMinecraftWarning(String langpath, Object replace) {
        Alert.showAsyncWarning(this.lang.get("launcher.warning.title"), this.lang.get("launcher.warning." + langpath, replace));
    }

    @Override
    public void onMinecraftCrash(Crash crash) {
        Crash.handle(crash);
    }

    @Override
    public void onUpdateError(Update u, Throwable e) {
        Blocker.unblock(this, UPDATER_BLOCK);
    }

    @Override
    public void onUpdateDownloading(Update u) {
        Blocker.block(this, UPDATER_BLOCK);
    }

    @Override
    public void onUpdateDownloadError(Update u, Throwable e) {
        Blocker.unblock(this, UPDATER_BLOCK);
    }

    @Override
    public void onUpdateReady(Update u) {
    }

    @Override
    public void onUpdateApplying(Update u) {
    }

    @Override
    public void onUpdateApplyError(Update u, Throwable e) {
    }

    @Override
    public void onUpdaterRequesting(Updater u) {
    }

    @Override
    public void onUpdaterRequestError(Updater u) {
    }

    @Override
    public void onUpdateFound(Update upd) {
        if (!Updater.isAutomode()) {
            return;
        }
        upd.addListener(this);
        Blocker.block(this, UPDATER_BLOCK);
    }

    @Override
    public void onUpdaterNotFoundUpdate(Updater u) {
    }

    @Override
    public void onAdFound(Updater u, Ad ad) {
    }

    class LoginThread
    extends Thread {
        private final LoginForm loginForm;
        private boolean isStarted;
        private boolean isRunning;

        LoginThread(LoginForm loginForm2) {
            this.loginForm = loginForm2;
        }

        @Override
        public void start() {
            if (this.isRunning) {
                LoginForm.this.log(new Object[]{"LoginThread is runned before and hasn't been stopped yet."});
                return;
            }
            this.isRunning = true;
            if (this.isStarted) {
                return;
            }
            this.isStarted = true;
            super.start();
        }

        @Override
        public void run() {
            Blocker.block(this.loginForm, LoginForm.LOGIN_BLOCK);
            try {
                this.loginForm.runLogin();
            }
            catch (Throwable e) {
                Alert.showError(e, false);
            }
            Blocker.unblock(this.loginForm, LoginForm.LOGIN_BLOCK);
            this.isRunning = false;
            while (!this.isRunning) {
                U.sleepFor(100L);
            }
            this.run();
        }
    }
}

