/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.login;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.component.managers.VersionManager;
import com.turikhay.tlauncher.component.managers.VersionManagerListener;
import com.turikhay.tlauncher.ui.alert.Alert;
import com.turikhay.tlauncher.ui.block.Blockable;
import com.turikhay.tlauncher.ui.loc.LocalizableComponent;
import com.turikhay.tlauncher.ui.login.LoginException;
import com.turikhay.tlauncher.ui.login.LoginForm;
import com.turikhay.tlauncher.ui.login.LoginListener;
import com.turikhay.tlauncher.ui.login.LoginWaitException;
import com.turikhay.tlauncher.ui.swing.VersionCellRenderer;
import com.turikhay.tlauncher.ui.swing.extended.ExtendedComboBox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.List;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;

public class VersionComboBox
extends ExtendedComboBox<VersionSyncInfo>
implements Blockable,
VersionManagerListener,
LocalizableComponent,
LoginListener {
    private static final long serialVersionUID = -9122074452728842733L;
    protected static final VersionSyncInfo LOADING = VersionCellRenderer.LOADING;
    protected static final VersionSyncInfo EMPTY = VersionCellRenderer.EMPTY;
    private final VersionManager manager;
    private final LoginForm loginForm;
    private String selectedVersion;

    VersionComboBox(LoginForm lf) {
        super(new VersionCellRenderer());
        this.loginForm = lf;
        this.manager = TLauncher.getInstance().getVersionManager();
        this.manager.addListener(this);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((VersionComboBox)VersionComboBox.this).loginForm.buttons.play.updateState();
                VersionSyncInfo selected = VersionComboBox.this.getVersion();
                if (selected != null) {
                    VersionComboBox.this.selectedVersion = selected.getID();
                }
            }
        });
        this.selectedVersion = lf.global.get("login.version");
    }

    public VersionSyncInfo getVersion() {
        VersionSyncInfo selected = (VersionSyncInfo)this.getSelectedItem();
        return selected == null || selected.equals(LOADING) || selected.equals(EMPTY) ? null : selected;
    }

    @Override
    public void onLogin() throws LoginException {
        VersionSyncInfo selected = this.getVersion();
        if (selected == null) {
            throw new LoginWaitException("Version list is empty, refreshing", new LoginWaitException.LoginWaitTask(){

                @Override
                public void runTask() throws LoginException {
                    VersionComboBox.this.manager.startRefresh();
                    if (VersionComboBox.this.getVersion() == null) {
                        Alert.showError("versions.notfound");
                    }
                    throw new LoginException("Giving user a second chance to choose correct version...");
                }
            });
        }
        if (!selected.hasRemote() || !selected.isInstalled() || selected.isUpToDate()) {
            return;
        }
        if (!Alert.showQuestion("versions.found-update", false)) {
            try {
                CompleteVersion complete = this.manager.getLocalList().getCompleteVersion(selected.getLocal());
                complete.setUpdatedTime(selected.getLatestVersion().getUpdatedTime());
                this.manager.getLocalList().saveVersion(complete);
            }
            catch (IOException e) {
                Alert.showError("versions.found-update.error");
            }
            return;
        }
        this.loginForm.checkbox.forceupdate.setSelected(false);
    }

    @Override
    public void onLoginFailed() {
    }

    @Override
    public void onLoginSuccess() {
    }

    @Override
    public void updateLocale() {
        this.updateList(this.manager.getVersions(), null);
    }

    @Override
    public void onVersionsRefreshing(VersionManager vm) {
        this.updateList(null, null);
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager vm) {
        this.updateList(this.manager.getVersions(), null);
    }

    @Override
    public void onVersionsRefreshed(VersionManager vm) {
        this.updateList(this.manager.getVersions(), null);
    }

    public void updateList(List<VersionSyncInfo> list, String select) {
        if (select == null && this.selectedVersion != null) {
            select = this.selectedVersion;
        }
        this.removeAllItems();
        if (list == null) {
            this.addItem(LOADING);
            return;
        }
        if (list.isEmpty()) {
            this.addItem(EMPTY);
        } else {
            for (VersionSyncInfo version : list) {
                this.addItem(version);
                if (select == null || !select.equals(version.getID())) continue;
                this.setSelectedItem(version);
            }
        }
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }
}

