/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.login.buttons;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.configuration.LangConfiguration;
import com.turikhay.tlauncher.ui.alert.Alert;
import com.turikhay.tlauncher.ui.block.Blockable;
import com.turikhay.tlauncher.ui.loc.LocalizableComponent;
import com.turikhay.tlauncher.ui.login.LoginForm;
import com.turikhay.tlauncher.ui.swing.ImageButton;
import com.turikhay.util.U;
import com.turikhay.util.async.AsyncThread;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URL;
import net.minecraft.launcher.OperatingSystem;

public class SupportButton
extends ImageButton
implements Blockable,
LocalizableComponent {
    private static final long serialVersionUID = 7903730373496194592L;
    private final SupportButton instance = this;
    private final LoginForm lf;
    private final LangConfiguration l;
    private String path;
    private URL url;
    private URI uri;
    private final Image vk = SupportButton.loadImage("vk.png");
    private final Image mail = SupportButton.loadImage("mail.png");

    SupportButton(LoginForm loginform) {
        this.lf = loginform;
        this.l = this.lf.lang;
        this.image = this.selectImage();
        this.rotation = ImageButton.ImageRotation.CENTER;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SupportButton.this.instance.openURL();
                SupportButton.this.lf.defocus();
            }
        });
        this.updateURL();
        this.initImage();
    }

    public void openURL() {
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                if (!OperatingSystem.openLink(SupportButton.this.uri)) {
                    Alert.showError(SupportButton.this.l.get("support.error.title"), SupportButton.this.l.get("support.error"), SupportButton.this.path);
                }
            }
        });
    }

    private Image selectImage() {
        String locale = TLauncher.getInstance().getSettings().getLocale().toString();
        if (locale.equals("ru_RU") || locale.equals("uk_UA")) {
            return this.vk;
        }
        return this.mail;
    }

    private void updateURL() {
        this.path = this.l.get("support.url");
        this.url = U.makeURL(this.path);
        this.uri = U.makeURI(this.url);
    }

    @Override
    public void updateLocale() {
        this.image = this.selectImage();
        this.updateURL();
    }

    @Override
    public void block(Object reason) {
    }

    @Override
    public void unblock(Object reason) {
    }
}

