/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.settings;

import com.turikhay.tlauncher.ui.block.Blocker;
import com.turikhay.tlauncher.ui.settings.SettingsField;
import com.turikhay.tlauncher.ui.settings.SettingsHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusListener;

public class SettingsFieldHandler
extends SettingsHandler {
    private final SettingsField field;
    private final Component component;

    SettingsFieldHandler(String path, Component comp, FocusListener focus) {
        super(path);
        if (!(comp instanceof SettingsField)) {
            throw new IllegalArgumentException();
        }
        if (focus != null) {
            this.addFocus(comp, focus);
        }
        this.component = comp;
        this.field = (SettingsField)((Object)comp);
    }

    SettingsFieldHandler(String path, Component comp) {
        this(path, comp, null);
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public String getValue() {
        return this.field.getSettingsValue();
    }

    @Override
    protected void setValue0(String s) {
        this.field.setSettingsValue(s);
    }

    @Override
    public boolean isValid() {
        return this.field.isValueValid();
    }

    private void addFocus(Component comp, FocusListener focus) {
        comp.addFocusListener(focus);
        if (comp instanceof Container) {
            Component[] componentArray = ((Container)comp).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component curComp = componentArray[n2];
                this.addFocus(curComp, focus);
                ++n2;
            }
        }
    }

    @Override
    public void block(Object reason) {
        Blocker.blockComponents(reason, this.getComponent());
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblockComponents(reason, this.getComponent());
    }
}

