/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.settings;

import com.turikhay.tlauncher.TLauncher;
import com.turikhay.tlauncher.configuration.Configuration;
import com.turikhay.tlauncher.ui.alert.Alert;
import com.turikhay.tlauncher.ui.block.Blocker;
import com.turikhay.tlauncher.ui.center.CenterPanel;
import com.turikhay.tlauncher.ui.converter.ActionOnLaunchConverter;
import com.turikhay.tlauncher.ui.converter.ConnectionQualityConverter;
import com.turikhay.tlauncher.ui.converter.ConsoleTypeConverter;
import com.turikhay.tlauncher.ui.converter.LocaleConverter;
import com.turikhay.tlauncher.ui.loc.LocalizableButton;
import com.turikhay.tlauncher.ui.loc.LocalizableLabel;
import com.turikhay.tlauncher.ui.login.LoginException;
import com.turikhay.tlauncher.ui.login.LoginListener;
import com.turikhay.tlauncher.ui.scenes.DefaultScene;
import com.turikhay.tlauncher.ui.settings.SettingsCheckBox;
import com.turikhay.tlauncher.ui.settings.SettingsComboBox;
import com.turikhay.tlauncher.ui.settings.SettingsFieldChangeListener;
import com.turikhay.tlauncher.ui.settings.SettingsFieldHandler;
import com.turikhay.tlauncher.ui.settings.SettingsGroupHandler;
import com.turikhay.tlauncher.ui.settings.SettingsHandler;
import com.turikhay.tlauncher.ui.settings.SettingsPair;
import com.turikhay.tlauncher.ui.settings.SettingsResolutionField;
import com.turikhay.tlauncher.ui.settings.SettingsTextField;
import com.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import com.turikhay.tlauncher.ui.swing.extended.VPanel;
import com.turikhay.util.U;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JScrollPane;
import net.minecraft.launcher.versions.ReleaseType;

public class SettingsPanel
extends CenterPanel
implements LoginListener {
    private static final long serialVersionUID = 3896900830909661270L;
    private static final int PANELS = 4;
    public final DefaultScene scene;
    private final JScrollPane scrollPane;
    protected final ExtendedPanel container;
    protected final ExtendedPanel[] panels;
    protected final GridBagConstraints[] constraints;
    public final SettingsFieldHandler directory;
    public final SettingsFieldHandler resolution;
    public final SettingsFieldHandler javaPath;
    public final SettingsFieldHandler javaArgs;
    public final SettingsFieldHandler args;
    public final SettingsFieldHandler console;
    public final SettingsFieldHandler connection;
    public final SettingsFieldHandler action;
    public final SettingsFieldHandler lang;
    public final SettingsGroupHandler versionHandler;
    protected final LocalizableButton saveButton;
    protected final LocalizableButton defaultButton;
    protected final List<SettingsHandler> handlers;

    public SettingsPanel(DefaultScene sc) {
        super(squareInsets);
        this.scene = sc;
        FocusListener warning = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SettingsPanel.this.setMessage("settings.warning");
            }

            @Override
            public void focusLost(FocusEvent e) {
                SettingsPanel.this.setMessage(null);
            }
        };
        FocusListener restart = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SettingsPanel.this.setMessage("settings.restart");
            }

            @Override
            public void focusLost(FocusEvent e) {
                SettingsPanel.this.setMessage(null);
            }
        };
        this.container = new ExtendedPanel();
        this.container.setLayout(new BoxLayout(this.container, 3));
        this.panels = new ExtendedPanel[4];
        this.constraints = new GridBagConstraints[4];
        int i = 0;
        while (i < 4) {
            this.panels[i] = new ExtendedPanel(new GridBagLayout());
            this.panels[i].getInsets().set(0, 0, 0, 0);
            this.constraints[i] = new GridBagConstraints();
            this.constraints[i].fill = 2;
            this.container.add((Component)this.panels[i], (Component)this.del(0));
            ++i;
        }
        this.handlers = new ArrayList<SettingsHandler>();
        int pane = 0;
        int row = 0;
        this.directory = new SettingsFieldHandler("minecraft.gamedir", new SettingsTextField("settings.client.gamedir.prompt"), warning);
        this.directory.addListener(new SettingsFieldChangeListener(){

            @Override
            protected void onChange(String oldValue, String newValue) {
                if (!SettingsPanel.this.tlauncher.isReady()) {
                    return;
                }
                try {
                    SettingsPanel.this.tlauncher.getManager().getVersionLists().updateLocal();
                }
                catch (IOException e) {
                    Alert.showError("settings.client.gamedir.noaccess", e);
                }
                SettingsPanel.this.tlauncher.getVersionManager().asyncRefresh();
            }
        });
        int n = row;
        row = (byte)(n + 1);
        this.add(pane, n, new SettingsPair("settings.client.gamedir.label", this.directory));
        this.resolution = new SettingsFieldHandler("minecraft.size", new SettingsResolutionField("settings.client.resolution.width", "settings.client.resolution.height", this.global), restart);
        int n2 = row;
        row = (byte)(n2 + 1);
        this.add(pane, n2, new SettingsPair("settings.client.resolution.label", this.resolution));
        pane = (byte)(pane + 1);
        row = 0;
        ReleaseType[] releaseTypes = ReleaseType.getDefinable();
        SettingsHandler[] versions = new SettingsFieldHandler[releaseTypes.length];
        int i2 = 0;
        while (i2 < releaseTypes.length) {
            ReleaseType releaseType = releaseTypes[i2];
            versions[i2] = new SettingsFieldHandler("minecraft.versions." + (Object)((Object)releaseType), new SettingsCheckBox("settings.versions." + (Object)((Object)releaseType)));
            ++i2;
        }
        this.versionHandler = new SettingsGroupHandler(versions);
        this.versionHandler.addListener(new SettingsFieldChangeListener(){

            @Override
            protected void onChange(String oldvalue, String newvalue) {
                TLauncher.getInstance().getVersionManager().updateVersionList();
            }
        });
        int n3 = row;
        row = (byte)(n3 + 1);
        this.add(pane, n3, new SettingsPair("settings.versions.label", versions));
        pane = (byte)(pane + 1);
        row = 0;
        this.javaArgs = new SettingsFieldHandler("minecraft.javaargs", new SettingsTextField("settings.java.args.jvm", true), warning);
        this.args = new SettingsFieldHandler("minecraft.args", new SettingsTextField("settings.java.args.minecraft", true), warning);
        int n4 = row;
        row = (byte)(n4 + 1);
        this.add(pane, n4, new SettingsPair("settings.java.args.label", this.javaArgs, this.args));
        this.javaPath = new SettingsFieldHandler("minecraft.javadir", new SettingsTextField("settings.java.path.prompt", true), warning);
        int n5 = row;
        row = (byte)(n5 + 1);
        this.add(pane, n5, new SettingsPair("settings.java.path.label", this.javaPath));
        pane = (byte)(pane + 1);
        row = 0;
        this.console = new SettingsFieldHandler("gui.console", new SettingsComboBox<Configuration.ConsoleType>(new ConsoleTypeConverter(), Configuration.ConsoleType.values()));
        this.console.addListener(new SettingsFieldChangeListener(){

            @Override
            protected void onChange(String oldvalue, String newvalue) {
                if (newvalue == null) {
                    return;
                }
                switch (Configuration.ConsoleType.get(newvalue)) {
                    case GLOBAL: {
                        TLauncher.getConsole().show(false);
                        break;
                    }
                    case MINECRAFT: 
                    case NONE: {
                        TLauncher.getConsole().hide();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown console type!");
                    }
                }
            }
        });
        int n6 = row;
        row = (byte)(n6 + 1);
        this.add(pane, n6, new SettingsPair("settings.console.label", this.console));
        this.connection = new SettingsFieldHandler("connection", new SettingsComboBox<Configuration.ConnectionQuality>(new ConnectionQualityConverter(), Configuration.ConnectionQuality.values()));
        int n7 = row;
        row = (byte)(n7 + 1);
        this.add(pane, n7, new SettingsPair("settings.connection.label", this.connection));
        this.action = new SettingsFieldHandler("minecraft.onlaunch", new SettingsComboBox<Configuration.ActionOnLaunch>(new ActionOnLaunchConverter(), Configuration.ActionOnLaunch.values()));
        int n8 = row;
        row = (byte)(n8 + 1);
        this.add(pane, n8, new SettingsPair("settings.launch-action.label", this.action));
        this.lang = new SettingsFieldHandler("locale", new SettingsComboBox<Locale>(new LocaleConverter(), this.global.getLocales()));
        this.lang.addListener(new SettingsFieldChangeListener(){

            @Override
            protected void onChange(String oldvalue, String newvalue) {
                if (SettingsPanel.this.tlauncher.getFrame() != null) {
                    SettingsPanel.this.tlauncher.getFrame().updateLocales();
                }
            }
        });
        int n9 = row;
        row = (byte)(n9 + 1);
        this.add(pane, n9, new SettingsPair("settings.lang.label", this.lang));
        this.saveButton = new LocalizableButton("settings.save");
        this.saveButton.setFont(this.saveButton.getFont().deriveFont(1));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SettingsPanel.this.saveValues()) {
                    SettingsPanel.this.scene.setSettings(false);
                }
            }
        });
        this.defaultButton = new LocalizableButton("settings.default");
        this.defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPanel.this.resetValues();
            }
        });
        this.container.add((Component)SettingsPanel.sepPan(this.saveButton, this.defaultButton));
        this.scrollPane = new JScrollPane(this.container);
        this.scrollPane.setOpaque(false);
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setBorder(null);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)this.messagePanel, (Component)this.scrollPane);
        this.updateValues();
    }

    protected void add(int pane, int row, SettingsPair pair) {
        LocalizableLabel label = pair.getLabel();
        VPanel field = pair.getPanel();
        ExtendedPanel panel = this.panels[pane];
        GridBagConstraints c = this.constraints[pane];
        c.anchor = 17;
        c.gridy = row;
        c.gridx = 0;
        c.weightx = 0.1;
        panel.add((Component)label, c);
        c.anchor = 13;
        c.gridy = row++;
        c.gridx = 1;
        c.weightx = 1.0;
        panel.add((Component)field, c);
        Collections.addAll(this.handlers, pair.getHandlers());
    }

    protected boolean checkValues() {
        boolean allValid = true;
        for (SettingsHandler handler : this.handlers) {
            boolean valid = handler.isValid();
            handler.getComponent().setBackground(valid ? this.getTheme().getBackground() : this.getTheme().getFailure());
            if (valid) continue;
            allValid = false;
        }
        return allValid;
    }

    public void updateValues() {
        boolean globalUnSaveable = !this.global.isSaveable();
        for (SettingsHandler handler : this.handlers) {
            String path = handler.getPath();
            String value = this.global.get(path);
            handler.setValue(value);
            if (!globalUnSaveable && this.global.isSaveable(path)) continue;
            Blocker.block(handler, "unsaveable");
        }
    }

    public boolean saveValues() {
        if (!this.checkValues()) {
            return false;
        }
        for (SettingsHandler handler : this.handlers) {
            String path = handler.getPath();
            String value = handler.getValue();
            this.global.set(path, value, false);
            handler.onChange(value);
        }
        this.global.store();
        return true;
    }

    public void resetValues() {
        for (SettingsHandler handler : this.handlers) {
            String path = handler.getPath();
            String value = this.global.getDefault(path);
            this.log("Resetting:", handler.getClass().getSimpleName(), path, value);
            if (value == null) continue;
            this.log("Reset!");
            handler.setValue(value);
        }
    }

    @Override
    public void block(Object reason) {
        Blocker.blockComponents(this.container, reason);
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblockComponents(this.container, reason);
    }

    @Override
    public void onLogin() throws LoginException {
        if (this.checkValues()) {
            return;
        }
        this.scene.setSettings(true);
        throw new LoginException("Invalid settings!");
    }

    @Override
    public void onLoginFailed() {
    }

    @Override
    public void onLoginSuccess() {
    }

    @Override
    protected void log(Object ... o) {
        U.log("[SettingsPanel]", o);
    }
}

