/*
 * Decompiled with CFR 0.152.
 */
package com.turikhay.tlauncher.ui.swing;

import com.turikhay.tlauncher.ui.images.ImageCache;
import com.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import com.turikhay.util.U;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ImagePanel
extends ExtendedPanel {
    private static final long serialVersionUID = 1L;
    public static final float DEFAULT_ACTIVE_OPACITY = 1.0f;
    public static final float DEFAULT_NON_ACTIVE_OPACITY = 0.75f;
    protected Object animationLock = new Object();
    protected Image image;
    protected float activeOpacity;
    protected float nonActiveOpacity;
    protected boolean antiAlias;
    protected int timeFrame;
    protected float opacity;
    protected boolean hover;
    protected boolean shown;
    protected boolean animating;

    public ImagePanel(String image, float activeOpacity, float nonActiveOpacity, boolean shown, boolean antiAlias) {
        this(ImageCache.getImage(image), activeOpacity, nonActiveOpacity, shown, antiAlias);
    }

    public ImagePanel(Image image, float activeOpacity, float nonActiveOpacity, boolean shown, boolean antiAlias) {
        this.setImage(image);
        this.setActiveOpacity(activeOpacity);
        this.setNonActiveOpacity(nonActiveOpacity);
        this.setAntiAlias(antiAlias);
        this.shown = shown;
        this.opacity = shown ? nonActiveOpacity : 0.0f;
        this.timeFrame = 10;
        this.setBackground(new Color(0, 0, 0, 0));
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImagePanel.this.onClick();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ImagePanel.this.onMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ImagePanel.this.onMouseExited();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Image image, boolean resetSize) {
        if (image == null) {
            throw new NullPointerException();
        }
        Object object = this.animationLock;
        synchronized (object) {
            this.image = image;
            this.setSize(image.getWidth(null), image.getHeight(null));
        }
    }

    public void setImage(Image image) {
        this.setImage(image, true);
    }

    public void setActiveOpacity(float opacity) {
        if (opacity > 1.0f || opacity < 0.0f) {
            throw new IllegalArgumentException("Invalid opacity! Condition: 0.0F <= opacity (got: " + opacity + ") <= 1.0F");
        }
        this.activeOpacity = opacity;
    }

    public void setNonActiveOpacity(float opacity) {
        if (opacity > 1.0f || opacity < 0.0f) {
            throw new IllegalArgumentException("Invalid opacity! Condition: 0.0F <= opacity (got: " + opacity + ") <= 1.0F");
        }
        this.nonActiveOpacity = opacity;
    }

    public void setAntiAlias(boolean set) {
        this.antiAlias = set;
    }

    @Override
    public void paintComponent(Graphics g0) {
        Graphics2D g = (Graphics2D)g0;
        Composite oldComp = g.getComposite();
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setComposite(AlphaComposite.getInstance(3, this.opacity));
        g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
        g.setComposite(oldComp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show() {
        if (this.shown) {
            return;
        }
        this.shown = true;
        Object object = this.animationLock;
        synchronized (object) {
            this.animating = true;
            this.setVisible(true);
            this.opacity = 0.0f;
            float selectedOpacity = this.hover ? this.activeOpacity : this.nonActiveOpacity;
            while (this.opacity < selectedOpacity) {
                this.opacity += 0.01f;
                if (this.opacity > selectedOpacity) {
                    this.opacity = selectedOpacity;
                }
                this.repaint();
                U.sleepFor(this.timeFrame);
            }
            this.animating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hide() {
        if (!this.shown) {
            return;
        }
        this.shown = false;
        Object object = this.animationLock;
        synchronized (object) {
            this.animating = true;
            while (this.opacity > 0.0f) {
                this.opacity -= 0.01f;
                if (this.opacity < 0.0f) {
                    this.opacity = 0.0f;
                }
                this.repaint();
                U.sleepFor(this.timeFrame);
            }
            this.setVisible(false);
            this.animating = false;
        }
    }

    protected boolean onClick() {
        return this.shown;
    }

    protected void onMouseEntered() {
        this.hover = true;
        if (this.animating || !this.shown) {
            return;
        }
        this.opacity = this.activeOpacity;
        this.repaint();
    }

    protected void onMouseExited() {
        this.hover = false;
        if (this.animating || !this.shown) {
            return;
        }
        this.opacity = this.nonActiveOpacity;
        this.repaint();
    }
}

